/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutTypePortlet;
import com.liferay.portal.model.Portlet;
import com.liferay.portal.model.PortletCategory;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.PortletLocalServiceUtil;
import com.liferay.portal.service.permission.PortletPermissionUtil;
import java.util.HashSet;
import java.util.Set;

public class PortletCategoryUtil {
    public static PortletCategory getRelevantPortletCategory(PermissionChecker permissionChecker, long companyId, Layout layout, PortletCategory portletCategory, LayoutTypePortlet layoutTypePortlet) throws Exception {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        Set panelSelectedPortletIds = SetUtil.fromArray((Object[])StringUtil.split((String)typeSettingsProperties.getProperty("panelSelectedPortlets")));
        return PortletCategoryUtil.getRelevantPortletCategory(permissionChecker, companyId, layout, portletCategory, panelSelectedPortletIds, layoutTypePortlet);
    }

    protected static PortletCategory getRelevantPortletCategory(PermissionChecker permissionChecker, long companyId, Layout layout, PortletCategory portletCategory, Set<String> panelSelectedPortletIds, LayoutTypePortlet layoutTypePortlet) throws Exception {
        PortletCategory relevantPortletCategory = new PortletCategory(portletCategory.getName(), portletCategory.getPortletIds());
        for (PortletCategory curPortletCategory : portletCategory.getCategories()) {
            HashSet<String> portletIds = new HashSet<String>();
            if (curPortletCategory.isHidden()) continue;
            for (String portletId : curPortletCategory.getPortletIds()) {
                Portlet portlet = PortletLocalServiceUtil.getPortletById((long)companyId, (String)portletId);
                if (portlet == null || portlet.isSystem() || !portlet.isActive() || portlet.isUndeployedPortlet()) continue;
                if (layout.isTypePanel() && panelSelectedPortletIds.contains(portlet.getRootPortletId())) {
                    portletIds.add(portlet.getPortletId());
                    continue;
                }
                if (layout.isTypePanel() && !panelSelectedPortletIds.contains(portlet.getRootPortletId()) || !PortletPermissionUtil.contains((PermissionChecker)permissionChecker, (Layout)layout, (Portlet)portlet, (String)"ADD_TO_PAGE")) continue;
                if (!portlet.isInstanceable() && layoutTypePortlet.hasPortletId(portlet.getPortletId())) {
                    portletIds.add(portlet.getPortletId());
                    continue;
                }
                portletIds.add(portlet.getPortletId());
            }
            PortletCategory curRelevantPortletCategory = PortletCategoryUtil.getRelevantPortletCategory(permissionChecker, companyId, layout, curPortletCategory, panelSelectedPortletIds, layoutTypePortlet);
            curRelevantPortletCategory.setPortletIds(portletIds);
            if (curRelevantPortletCategory.getCategories().isEmpty() && portletIds.isEmpty()) continue;
            relevantPortletCategory.addCategory(curRelevantPortletCategory);
        }
        return relevantPortletCategory;
    }
}

