/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBFactoryUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class VerifyDB2
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDB2.class);

    protected void alterVarcharColumns() throws Exception {
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getUpgradeOptimizedConnection();
            StringBundler sb = new StringBundler(4);
            sb.append("select tbname, name, coltype, length from ");
            sb.append("sysibm.syscolumns where tbcreator = (select distinct ");
            sb.append("current schema from sysibm.sysschemata) AND coltype = ");
            sb.append("'VARCHAR' and length = 500");
            ps = con.prepareStatement(sb.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                String tableName = rs.getString(1);
                if (!this.isPortalTableName(tableName)) continue;
                String columnName = rs.getString(2);
                this.runSQL("alter table " + tableName + " alter column " + columnName + " set data type varchar(600)");
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp((Connection)con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    protected void convertColumnToClob(String tableName, String columnName) throws Exception {
        StringBundler sb;
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block6: {
            block4: {
                block5: {
                    con = null;
                    ps = null;
                    rs = null;
                    try {
                        con = DataAccess.getUpgradeOptimizedConnection();
                        sb = new StringBundler(5);
                        sb.append("select coltype from sysibm.syscolumns where tbname = '");
                        sb.append(tableName);
                        sb.append("' AND name = '");
                        sb.append(columnName);
                        sb.append("'");
                        ps = con.prepareStatement(sb.toString());
                        rs = ps.executeQuery();
                        if (rs.next()) break block4;
                        if (!_log.isWarnEnabled()) break block5;
                        sb = new StringBundler(4);
                        sb.append("Unable to find column ");
                        sb.append(columnName);
                        sb.append(" in table ");
                        sb.append(tableName);
                        _log.warn((Object)sb.toString());
                    }
                    catch (Throwable throwable) {
                        DataAccess.cleanUp((Connection)con, ps, rs);
                        throw throwable;
                    }
                }
                DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
                return;
            }
            String dataType = rs.getString(1);
            if (!dataType.equals("CLOB")) break block6;
            DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
            return;
        }
        this.runSQL("alter table " + tableName + " add temp CLOB");
        sb = new StringBundler(4);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set temp = ");
        sb.append(columnName);
        this.runSQL(sb.toString());
        sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" drop column ");
        sb.append(columnName);
        this.runSQL(sb.toString());
        sb = new StringBundler(4);
        sb.append("alter table ");
        sb.append(tableName);
        sb.append(" rename column temp to ");
        sb.append(columnName);
        this.runSQL(sb.toString());
        DataAccess.cleanUp((Connection)con, (Statement)ps, (ResultSet)rs);
    }

    @Override
    protected void doVerify() throws Exception {
        DB db = DBFactoryUtil.getDB();
        String dbType = db.getType();
        if (!dbType.equals("db2")) {
            return;
        }
        this.alterVarcharColumns();
        this.convertColumnToClob("EXPANDOVALUE", "DATA_");
    }
}

