/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Organization;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.persistence.OrganizationActionableDynamicQuery;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.asset.service.AssetEntryLocalServiceUtil;
import java.util.List;

public class VerifyOrganization
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyOrganization.class);

    @Override
    protected void doVerify() throws Exception {
        this.rebuildTree();
        this.updateOrganizationAssets();
        this.updateOrganizationAssetEntries();
    }

    protected void rebuildTree() throws Exception {
        long[] companyIds;
        long[] lArray = companyIds = PortalInstances.getCompanyIdsBySQL();
        int n = companyIds.length;
        int n2 = 0;
        while (n2 < n) {
            long companyId = lArray[n2];
            OrganizationLocalServiceUtil.rebuildTree((long)companyId);
            ++n2;
        }
    }

    protected void updateOrganizationAssetEntries() throws Exception {
        OrganizationActionableDynamicQuery actionableDynamicQuery = new OrganizationActionableDynamicQuery(){

            protected void performAction(Object object) {
                block3: {
                    Organization organization = (Organization)object;
                    try {
                        AssetEntry assetEntry = AssetEntryLocalServiceUtil.getEntry((String)Organization.class.getName(), (long)organization.getOrganizationId());
                        if (Validator.isNotNull((String)assetEntry.getClassUuid())) {
                            return;
                        }
                        assetEntry.setClassUuid(organization.getUuid());
                        AssetEntryLocalServiceUtil.updateAssetEntry((AssetEntry)assetEntry);
                    }
                    catch (Exception e2) {
                        if (!_log.isWarnEnabled()) break block3;
                        _log.warn((Object)("Unable to update asset entry for organization " + organization.getOrganizationId()), (Throwable)e2);
                    }
                }
            }
        };
        actionableDynamicQuery.performActions();
    }

    protected void updateOrganizationAssets() throws Exception {
        List organizations = OrganizationLocalServiceUtil.getNoAssetOrganizations();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Processing " + organizations.size() + " organizations with " + "no asset"));
        }
        for (Organization organization : organizations) {
            try {
                OrganizationLocalServiceUtil.updateAsset((long)organization.getUserId(), (Organization)organization, null, null);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to update asset for organization " + organization.getOrganizationId() + ": " + e2.getMessage()));
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"Assets verified for organizations");
        }
    }
}

