/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletContext;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletFilterUtil;
import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.PortletApp;
import com.liferay.portal.model.PortletConstants;
import com.liferay.portal.model.impl.PortletFilterImpl;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.FilterChainImpl;
import com.liferay.portlet.InvokerPortlet;
import com.liferay.portlet.InvokerPortletResponse;
import com.liferay.portlet.PortletContextBag;
import com.liferay.portlet.PortletContextBagPool;
import com.liferay.portlet.PortletFilterFactory;
import com.liferay.portlet.PortletSessionImpl;
import com.liferay.portlet.RenderRequestImpl;
import com.liferay.portlet.RenderResponseImpl;
import com.liferay.portlet.StrutsPortlet;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.Portlet;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.filter.ActionFilter;
import javax.portlet.filter.EventFilter;
import javax.portlet.filter.FilterChain;
import javax.portlet.filter.PortletFilter;
import javax.portlet.filter.RenderFilter;
import javax.portlet.filter.ResourceFilter;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.time.StopWatch;

public class InvokerPortletImpl
implements InvokerPortlet {
    private static Log _log = LogFactoryUtil.getLog(InvokerPortletImpl.class);
    private List<ActionFilter> _actionFilters = new ArrayList<ActionFilter>();
    private boolean _checkAuthToken;
    private List<EventFilter> _eventFilters = new ArrayList<EventFilter>();
    private Integer _expCache;
    private boolean _facesPortlet;
    private LiferayPortletConfig _liferayPortletConfig;
    private LiferayPortletContext _liferayPortletContext;
    private Portlet _portlet;
    private String _portletId;
    private com.liferay.portal.model.Portlet _portletModel;
    private List<RenderFilter> _renderFilters = new ArrayList<RenderFilter>();
    private List<ResourceFilter> _resourceFilters = new ArrayList<ResourceFilter>();
    private boolean _strutsBridgePortlet;
    private boolean _strutsPortlet;
    private List<PortletFilter> _systemPortletFilters = new ArrayList<PortletFilter>();

    public static void clearResponse(HttpSession session, long plid, String portletId, String languageId) {
        String sesResponseId = InvokerPortletImpl.encodeResponseKey(plid, portletId, languageId);
        InvokerPortletImpl.getResponses(session).remove(sesResponseId);
    }

    public static void clearResponses(HttpSession session) {
        InvokerPortletImpl.getResponses(session).clear();
    }

    public static void clearResponses(PortletSession session) {
        InvokerPortletImpl.getResponses(session).clear();
    }

    public static String encodeResponseKey(long plid, String portletId, String languageId) {
        StringBundler sb = new StringBundler(5);
        sb.append(StringUtil.toHexString((long)plid));
        sb.append("_");
        sb.append(portletId);
        sb.append("_");
        sb.append(languageId);
        return sb.toString();
    }

    public static Map<String, InvokerPortletResponse> getResponses(HttpSession session) {
        ConcurrentHashMap responses = (ConcurrentHashMap)session.getAttribute("CACHE_PORTLET_RESPONSES");
        if (responses == null) {
            responses = new ConcurrentHashMap();
            session.setAttribute("CACHE_PORTLET_RESPONSES", responses);
        }
        return responses;
    }

    public static Map<String, InvokerPortletResponse> getResponses(PortletSession portletSession) {
        return InvokerPortletImpl.getResponses(((PortletSessionImpl)portletSession).getHttpSession());
    }

    public InvokerPortletImpl(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, boolean checkAuthToken, boolean facesPortlet, boolean strutsPortlet, boolean strutsBridgePortlet) throws PortletException {
        this._initialize(portletModel, portlet, portletConfig, portletContext, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
    }

    public InvokerPortletImpl(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletContext portletContext) throws PortletException {
        Map initParams = portletModel.getInitParams();
        boolean checkAuthToken = GetterUtil.getBoolean((String)((String)initParams.get("check-auth-token")), (boolean)true);
        boolean facesPortlet = false;
        if (ClassUtil.isSubclass(portlet.getClass(), (String)"javax.portlet.faces.GenericFacesPortlet")) {
            facesPortlet = true;
        }
        boolean strutsPortlet = ClassUtil.isSubclass(portlet.getClass(), StrutsPortlet.class);
        boolean strutsBridgePortlet = ClassUtil.isSubclass(portlet.getClass(), (String)"org.apache.portals.bridges.struts.StrutsPortlet");
        this._initialize(portletModel, portlet, null, portletContext, checkAuthToken, facesPortlet, strutsPortlet, strutsBridgePortlet);
    }

    public void destroy() {
        if (PortletConstants.hasInstanceId((String)this._portletModel.getPortletId())) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Destroying an instanced portlet is not allowed");
            }
            return;
        }
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        ClassLoader portletClassLoader = this.getPortletClassLoader();
        try {
            if (portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader(portletClassLoader);
            }
            this.removePortletFilters();
            this._portlet.destroy();
        }
        finally {
            if (portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public Integer getExpCache() {
        return this._expCache;
    }

    public Portlet getPortlet() {
        return this._portlet;
    }

    public ClassLoader getPortletClassLoader() {
        ClassLoader classLoader = (ClassLoader)this._liferayPortletContext.getAttribute("PLUGIN_CLASS_LOADER");
        if (classLoader == null) {
            classLoader = ClassLoaderUtil.getPortalClassLoader();
        }
        return classLoader;
    }

    public PortletConfig getPortletConfig() {
        return this._liferayPortletConfig;
    }

    public PortletContext getPortletContext() {
        return this._liferayPortletContext;
    }

    public Portlet getPortletInstance() {
        return this._portlet;
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        ClassLoader contextClassLoader = ClassLoaderUtil.getContextClassLoader();
        ClassLoader portletClassLoader = this.getPortletClassLoader();
        try {
            if (portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader(portletClassLoader);
            }
            this._portlet.init(portletConfig);
        }
        finally {
            if (portletClassLoader != null) {
                ClassLoaderUtil.setContextClassLoader(contextClassLoader);
            }
        }
    }

    public boolean isCheckAuthToken() {
        return this._checkAuthToken;
    }

    public boolean isFacesPortlet() {
        return this._facesPortlet;
    }

    public boolean isStrutsBridgePortlet() {
        return this._strutsBridgePortlet;
    }

    public boolean isStrutsPortlet() {
        return this._strutsPortlet;
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeAction(actionRequest, actionResponse);
        }
        catch (PortletException pe) {
            actionRequest.setAttribute(String.valueOf(this._portletId) + PortletException.class.getName(), (Object)pe);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("processAction for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void processEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        this.invokeEvent(eventRequest, eventResponse);
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("processEvent for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void render(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        PortletException portletException = (PortletException)((Object)renderRequest.getAttribute(String.valueOf(this._portletId) + PortletException.class.getName()));
        if (portletException != null) {
            throw portletException;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String remoteUser = renderRequest.getRemoteUser();
        if (remoteUser == null || this._expCache == null || this._expCache == 0) {
            this.invokeRender(renderRequest, renderResponse);
        } else {
            String sessionResponseId;
            RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
            BufferCacheServletResponse bufferCacheServletResponse = (BufferCacheServletResponse)renderResponseImpl.getHttpServletResponse();
            PortletSession portletSession = renderRequest.getPortletSession();
            long now = System.currentTimeMillis();
            Layout layout = (Layout)renderRequest.getAttribute("LAYOUT");
            Map<String, InvokerPortletResponse> sessionResponses = InvokerPortletImpl.getResponses(portletSession);
            InvokerPortletResponse response = sessionResponses.get(sessionResponseId = InvokerPortletImpl.encodeResponseKey(layout.getPlid(), this._portletId, LanguageUtil.getLanguageId((PortletRequest)renderRequest)));
            if (response == null) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response = new InvokerPortletResponse(title, bufferCacheServletResponse.getString(), now + 1000L * (long)this._expCache.intValue());
                sessionResponses.put(sessionResponseId, response);
            } else if (response.getTime() < now && this._expCache > 0) {
                String title = this.invokeRender(renderRequest, renderResponse);
                response.setTitle(title);
                response.setContent(bufferCacheServletResponse.getString());
                response.setTime(now + 1000L * (long)this._expCache.intValue());
            } else {
                renderResponseImpl.setTitle(response.getTitle());
                PrintWriter printWriter = bufferCacheServletResponse.getWriter();
                printWriter.print(response.getContent());
            }
        }
        Map<String, String[]> properties = ((RenderResponseImpl)renderResponse).getProperties();
        if (properties.containsKey("clear-request-parameters")) {
            Map<String, String[]> renderParameters = ((RenderRequestImpl)renderRequest).getRenderParameters();
            renderParameters.clear();
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("render for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.invokeResource(resourceRequest, resourceResponse);
        }
        catch (PortletException pe) {
            resourceRequest.setAttribute(String.valueOf(this._portletId) + PortletException.class.getName(), (Object)pe);
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("serveResource for " + this._portletId + " takes " + stopWatch.getTime() + " ms"));
        }
    }

    public void setPortletFilters() throws PortletException {
        PortletApp portletApp = this._portletModel.getPortletApp();
        PortletContextBag portletContextBag = PortletContextBagPool.get(portletApp.getServletContextName());
        if (portletApp.isWARFile() && portletContextBag == null) {
            return;
        }
        this.removePortletFilters();
        Map portletFilters = this._portletModel.getPortletFilters();
        for (Map.Entry entry : portletFilters.entrySet()) {
            com.liferay.portal.model.PortletFilter portletFilterModel = (com.liferay.portal.model.PortletFilter)entry.getValue();
            PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, (PortletContext)this._liferayPortletContext);
            Set lifecycles = portletFilterModel.getLifecycles();
            if (lifecycles.contains("ACTION_PHASE")) {
                this._actionFilters.add((ActionFilter)portletFilter);
            }
            if (lifecycles.contains("EVENT_PHASE")) {
                this._eventFilters.add((EventFilter)portletFilter);
            }
            if (lifecycles.contains("RENDER_PHASE")) {
                this._renderFilters.add((RenderFilter)portletFilter);
            }
            if (!lifecycles.contains("RESOURCE_PHASE")) continue;
            this._resourceFilters.add((ResourceFilter)portletFilter);
        }
        ClassLoader classLoader = ClassLoaderUtil.getContextClassLoader();
        try {
            ClassLoaderUtil.setContextClassLoader(ClassLoaderUtil.getPortalClassLoader());
            String[] stringArray = PropsValues.PORTLET_FILTERS_SYSTEM;
            int n = PropsValues.PORTLET_FILTERS_SYSTEM.length;
            int n2 = 0;
            while (n2 < n) {
                String portletFilterClassName = stringArray[n2];
                PortletFilterImpl portletFilterModel = new PortletFilterImpl(portletFilterClassName, portletFilterClassName, Collections.<String>emptySet(), Collections.<String, String>emptyMap(), portletApp);
                PortletFilter portletFilter = PortletFilterFactory.create(portletFilterModel, (PortletContext)this._liferayPortletContext);
                this._systemPortletFilters.add(portletFilter);
                if (portletFilter instanceof ActionFilter) {
                    this._actionFilters.add((ActionFilter)portletFilter);
                }
                if (portletFilter instanceof EventFilter) {
                    this._eventFilters.add((EventFilter)portletFilter);
                }
                if (portletFilter instanceof RenderFilter) {
                    this._renderFilters.add((RenderFilter)portletFilter);
                }
                if (portletFilter instanceof ResourceFilter) {
                    this._resourceFilters.add((ResourceFilter)portletFilter);
                }
                ++n2;
            }
        }
        finally {
            ClassLoaderUtil.setContextClassLoader(classLoader);
        }
    }

    protected void invoke(LiferayPortletRequest portletRequest, LiferayPortletResponse portletResponse, String lifecycle, List<? extends PortletFilter> filters) throws IOException, PortletException {
        String[] expCache;
        FilterChainImpl filterChain = new FilterChainImpl(this._portlet, filters);
        if (this._liferayPortletConfig.isWARFile()) {
            String invokerPortletName = this._liferayPortletConfig.getInitParameter("com.liferay.portal.invokerPortletName");
            if (invokerPortletName == null) {
                invokerPortletName = this._liferayPortletConfig.getPortletName();
            }
            String path = "/" + invokerPortletName + "/invoke";
            ServletContext servletContext = this._liferayPortletContext.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(path);
            HttpServletRequest request = portletRequest.getHttpServletRequest();
            HttpServletResponse response = portletResponse.getHttpServletResponse();
            request.setAttribute("javax.portlet.portlet", (Object)this._portlet);
            request.setAttribute("javax.portlet.lifecycle_phase", (Object)lifecycle);
            request.setAttribute("com.liferay.portal.kernel.servlet.PortletServletFilterChain", (Object)filterChain);
            try {
                if (lifecycle.equals("RESOURCE_PHASE")) {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                }
                requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException se) {
                Throwable cause = se.getRootCause();
                if (cause instanceof PortletException) {
                    throw (PortletException)cause;
                }
                throw new PortletException(cause);
            }
        } else {
            PortletFilterUtil.doFilter((PortletRequest)portletRequest, (PortletResponse)portletResponse, (String)lifecycle, (FilterChain)filterChain);
        }
        portletResponse.transferMarkupHeadElements();
        Map properties = portletResponse.getProperties();
        if (properties != null && properties.size() > 0 && this._expCache != null && (expCache = (String[])properties.get("portlet.expiration-cache")) != null && expCache.length > 0 && expCache[0] != null) {
            this._expCache = new Integer(GetterUtil.getInteger((String)expCache[0]));
        }
    }

    protected void invokeAction(ActionRequest actionRequest, ActionResponse actionResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)actionRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)actionResponse;
        this.invoke(portletRequest, portletResponse, "ACTION_PHASE", this._actionFilters);
    }

    protected void invokeEvent(EventRequest eventRequest, EventResponse eventResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)eventRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)eventResponse;
        this.invoke(portletRequest, portletResponse, "EVENT_PHASE", this._eventFilters);
    }

    protected String invokeRender(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)renderRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)renderResponse;
        this.invoke(portletRequest, portletResponse, "RENDER_PHASE", this._renderFilters);
        RenderResponseImpl renderResponseImpl = (RenderResponseImpl)renderResponse;
        return renderResponseImpl.getTitle();
    }

    protected void invokeResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        LiferayPortletRequest portletRequest = (LiferayPortletRequest)resourceRequest;
        LiferayPortletResponse portletResponse = (LiferayPortletResponse)resourceResponse;
        this.invoke(portletRequest, portletResponse, "RESOURCE_PHASE", this._resourceFilters);
    }

    protected void removePortletFilters() {
        this._actionFilters.clear();
        this._eventFilters.clear();
        this._renderFilters.clear();
        this._resourceFilters.clear();
        for (PortletFilter portletFilter : this._systemPortletFilters) {
            portletFilter.destroy();
        }
        this._systemPortletFilters.clear();
    }

    private void _initialize(com.liferay.portal.model.Portlet portletModel, Portlet portlet, PortletConfig portletConfig, PortletContext portletContext, boolean checkAuthToken, boolean facesPortlet, boolean strutsPortlet, boolean strutsBridgePortlet) throws PortletException {
        this._portletModel = portletModel;
        this._portlet = portlet;
        this._liferayPortletConfig = (LiferayPortletConfig)portletConfig;
        this._portletId = this._portletModel.getPortletId();
        this._liferayPortletContext = (LiferayPortletContext)portletContext;
        this._checkAuthToken = checkAuthToken;
        this._facesPortlet = facesPortlet;
        this._strutsPortlet = strutsPortlet;
        this._strutsBridgePortlet = strutsBridgePortlet;
        this._expCache = portletModel.getExpCache();
        this.setPortletFilters();
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Create instance cache wrapper for " + this._liferayPortletContext.getPortlet().getPortletId()));
        }
    }
}

