/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.permission;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.staging.permission.StagingPermissionUtil;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.bookmarks.NoSuchFolderException;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.BookmarksFolderLocalServiceUtil;
import com.liferay.portlet.bookmarks.service.permission.BookmarksPermission;

public class BookmarksFolderPermission {
    public static void check(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) throws PortalException, SystemException {
        if (!BookmarksFolderPermission.contains(permissionChecker, folder, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (!BookmarksFolderPermission.contains(permissionChecker, groupId, folderId, actionId)) {
            throw new PrincipalException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) throws PortalException, SystemException {
        Boolean hasPermission;
        if (actionId.equals("ADD_FOLDER")) {
            actionId = "ADD_SUBFOLDER";
        }
        if ((hasPermission = StagingPermissionUtil.hasPermission((PermissionChecker)permissionChecker, (long)folder.getGroupId(), (String)BookmarksFolder.class.getName(), (long)folder.getFolderId(), (String)"28", (String)actionId)) != null) {
            return hasPermission;
        }
        if (!actionId.equals("VIEW")) return BookmarksFolderPermission._hasPermission(permissionChecker, folder, actionId);
        if (!PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) return BookmarksFolderPermission._hasPermission(permissionChecker, folder, actionId);
        try {
            long folderId = folder.getFolderId();
            while (true) {
                if (folderId == 0L) {
                    return BookmarksPermission.contains(permissionChecker, folder.getGroupId(), actionId);
                }
                folder = BookmarksFolderLocalServiceUtil.getFolder((long)folderId);
                if (!BookmarksFolderPermission._hasPermission(permissionChecker, folder, actionId)) {
                    return false;
                }
                folderId = folder.getParentFolderId();
            }
        }
        catch (NoSuchFolderException nsfe) {
            if (folder.isInTrash()) return BookmarksPermission.contains(permissionChecker, folder.getGroupId(), actionId);
            throw nsfe;
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) throws PortalException, SystemException {
        if (folderId == 0L) {
            return BookmarksPermission.contains(permissionChecker, groupId, actionId);
        }
        BookmarksFolder folder = BookmarksFolderLocalServiceUtil.getBookmarksFolder((long)folderId);
        return BookmarksFolderPermission.contains(permissionChecker, folder, actionId);
    }

    private static boolean _hasPermission(PermissionChecker permissionChecker, BookmarksFolder folder, String actionId) {
        return permissionChecker.hasOwnerPermission(folder.getCompanyId(), BookmarksFolder.class.getName(), folder.getFolderId(), folder.getUserId(), actionId) || permissionChecker.hasPermission(folder.getGroupId(), BookmarksFolder.class.getName(), folder.getFolderId(), actionId);
    }
}

