/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatalists.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordSetLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import java.util.List;
import java.util.Map;

public class DDLRecordSetStagedModelDataHandler
extends BaseStagedModelDataHandler<DDLRecordSet> {
    public static final String[] CLASS_NAMES = new String[]{DDLRecordSet.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DDLRecordSet ddlRecordSet = DDLRecordSetLocalServiceUtil.fetchDDLRecordSetByUuidAndGroupId((String)uuid, (long)groupId);
        if (ddlRecordSet != null) {
            DDLRecordSetLocalServiceUtil.deleteRecordSet((DDLRecordSet)ddlRecordSet);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(DDLRecordSet recordSet) {
        return recordSet.getNameCurrentValue();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)recordSet, (StagedModel)ddmStructure, (String)"strong");
        List ddmTemplates = ddmStructure.getTemplates();
        Element recordSetElement = portletDataContext.getExportDataElement((ClassedModel)recordSet);
        for (DDMTemplate ddmTemplate : ddmTemplates) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)recordSet, (StagedModel)ddmTemplate, (String)"strong");
        }
        portletDataContext.addClassedModel(recordSetElement, ExportImportPathUtil.getModelPath((StagedModel)recordSet), (ClassedModel)recordSet);
    }

    protected void doImportCompanyStagedModel(PortletDataContext portletDataContext, String uuid, long recordSetId) throws Exception {
        DDLRecordSet existingRecordSet = DDLRecordSetLocalServiceUtil.fetchDDLRecordSetByUuidAndGroupId((String)uuid, (long)portletDataContext.getCompanyGroupId());
        Map recordSetIds = portletDataContext.getNewPrimaryKeysMap(DDLRecordSet.class);
        recordSetIds.put(recordSetId, existingRecordSet.getRecordSetId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DDLRecordSet recordSet) throws Exception {
        long userId = portletDataContext.getUserId(recordSet.getUserUuid());
        StagedModelDataHandlerUtil.importReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)recordSet, DDMStructure.class, (long)recordSet.getDDMStructureId());
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        long ddmStructureId = MapUtil.getLong((Map)ddmStructureIds, (long)recordSet.getDDMStructureId(), (long)recordSet.getDDMStructureId());
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)recordSet, DDMTemplate.class);
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)recordSet);
        DDLRecordSet importedRecordSet = null;
        if (portletDataContext.isDataStrategyMirror()) {
            DDLRecordSet existingRecordSet = DDLRecordSetLocalServiceUtil.fetchDDLRecordSetByUuidAndGroupId((String)recordSet.getUuid(), (long)portletDataContext.getScopeGroupId());
            if (existingRecordSet == null) {
                serviceContext.setUuid(recordSet.getUuid());
                importedRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)userId, (long)portletDataContext.getScopeGroupId(), (long)ddmStructureId, (String)recordSet.getRecordSetKey(), (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (int)recordSet.getScope(), (ServiceContext)serviceContext);
            } else {
                importedRecordSet = DDLRecordSetLocalServiceUtil.updateRecordSet((long)existingRecordSet.getRecordSetId(), (long)ddmStructureId, (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (ServiceContext)serviceContext);
            }
        } else {
            importedRecordSet = DDLRecordSetLocalServiceUtil.addRecordSet((long)userId, (long)portletDataContext.getScopeGroupId(), (long)ddmStructureId, (String)recordSet.getRecordSetKey(), (Map)recordSet.getNameMap(), (Map)recordSet.getDescriptionMap(), (int)recordSet.getMinDisplayRows(), (int)recordSet.getScope(), (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)recordSet, (ClassedModel)importedRecordSet);
    }
}

