/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.translators;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portlet.wiki.translators.BaseTranslator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MediaWikiToCreoleTranslator
extends BaseTranslator {
    public static final String TABLE_OF_CONTENTS = "<<TableOfContents>>\n\n";
    private static final String[] _HTML_TAGS = new String[]{"<blockquote>", "</blockquote>", "<br>", "<br/>", "<br />", "<center>", "</center>", "<cite>", "</cite>", "<code>", "</code>", "<div[^>]*>", "</div>", "<font[^>]*>", "</font>", "<hr>", "<hr/>", "<hr />", "<p>", "</p>", "<tt>", "</tt>", "<var>", "</var>"};
    private boolean _strictImportMode;

    public MediaWikiToCreoleTranslator() {
        this.initRegexps();
        this.initNowikiRegexps();
    }

    public boolean isStrictImportMode() {
        return this._strictImportMode;
    }

    public void setStrictImportMode(boolean strictImportMode) {
        this._strictImportMode = strictImportMode;
    }

    protected void initNowikiRegexps() {
        this.nowikiRegexps.add("(<nowiki>)(.*?)(</nowiki>)");
        this.nowikiRegexps.add("(<pre>)(.*?)(</pre>)");
        this.nowikiRegexps.add("~(\\*\\*|~|//|-|#|\\{\\{|}}|\\\\|~\\[~~[|]]|----|=|\\|)");
    }

    protected void initRegexps() {
        this.regexps.put("= '''([^=]+)''' =", "= $1 =");
        this.regexps.put("== '''([^=]+)''' ==", "== $1 ==");
        this.regexps.put("== '''([^=]+)''' ===", "=== $1 ===");
        this.regexps.put("&lt;", "<");
        this.regexps.put("&gt;", ">");
        this.regexps.put("\\[\\[[Cc]ategory:([^\\]]*)\\]\\][\\n]*", "");
        this.regexps.put("\\{{2}OtherTopics\\|([^\\}]*)\\}{2}", "");
        this.regexps.put("\\{{2}Work in progress\\}{2}", "");
        this.regexps.put("\\[{2}Wikipedia:([^\\]]*)\\]{2}", "");
        this.regexps.put("''''((?s:.)*?)(''''|(\n\n|\r\r|\r\n\r\n))", "**//$1//**$3");
        this.regexps.put("'''((?s:.)*?)('''|(\n\n|\r\r|\r\n\r\n))", "**$1**$3");
        this.regexps.put("''((?s:.)*?)(''|(\n\n|\r\r|\r\n\r\n))", "//$1//$3");
        this.regexps.put("\\[{2}((http|ftp)[^ ]*) ([^\\]]*)\\]{2}", "[$1 $3]");
        this.regexps.put("\\[((http|ftp)[^ ]*)\\]", "[[$1]]");
        this.regexps.put("\\[((http|ftp)[^ ]*) ([^\\]]*)\\]", "[[$1|$3]]");
        this.regexps.put("^\\t([\\w]+):\\t(.*)", "**$1**:\n$2");
        this.regexps.put("^\\t:\\t(.*)", "$1");
        this.regexps.put("(^ (.+))(\\n (.+))*", "{{{\n$0\n}}}");
        this.regexps.put("<nowiki>([^<]*)</nowiki>", "{{{$1}}}");
        this.regexps.put("<pre>([^<]*)</pre>", "{{{$1}}}");
        this.regexps.put("[-]*\\[{2}User:([^\\]]*)\\]{2}", "$1");
    }

    @Override
    protected String postProcess(String content) {
        if (this._strictImportMode) {
            content = this.runRegexp(content, "\\{{2}Special:(.*?)\\}{2}", "");
            content = this.runRegexp(content, "\\{{2}(.*?)\\}{2}", "");
            content = this.runRegexp(content, "(?s)\\{{2}(.*?)\\}{2}", "");
        } else {
            content = this.runRegexp(content, "\\{{2}Special:(.*?)\\}{2}", "{{{$1}}}\n");
            content = this.runRegexp(content, "\\{{2}(.*?)\\}{2}", "{{{$1}}}");
            content = this.runRegexp(content, "([^\\{])(\\{{2})([^\\{])", "$1\n{{{\n$3");
            content = this.runRegexp(content, "([^\\}])(\\}{2})([^\\}])", "$1\n}}}\n$3");
        }
        Pattern pattern = Pattern.compile("^=([^=]+)=", 8);
        Matcher matcher = pattern.matcher(content);
        if (matcher.find()) {
            content = this.runRegexp(content, "^===([^=]+)===", "====$1====");
            content = this.runRegexp(content, "^==([^=]+)==", "===$1===");
            content = this.runRegexp(content, "^=([^=]+)=", "==$1==");
        }
        int i2 = 0;
        while (i2 < _HTML_TAGS.length) {
            content = content.replaceAll(_HTML_TAGS[i2], "");
            ++i2;
        }
        pattern = Pattern.compile("(\\[{2})(Image|File)(:)", 32);
        matcher = pattern.matcher(content);
        StringBuffer sb = new StringBuffer(content);
        int level = 0;
        int offset = 0;
        int originalLength = 0;
        int prefixLength = 0;
        while (matcher.find()) {
            level = 0;
            prefixLength = matcher.end(2) - matcher.start(2);
            int i3 = matcher.start(0) + offset;
            while (i3 < sb.length() - 1) {
                if (sb.charAt(i3) == '[' && sb.charAt(i3 + 1) == '[') {
                    ++level;
                } else if (sb.charAt(i3) == ']' && sb.charAt(i3 + 1) == ']' && --level == 0) {
                    originalLength = i3 + 2 - (matcher.start(0) + offset);
                    break;
                }
                ++i3;
            }
            int imageStartPos = matcher.end(3) + offset;
            int imageEndPos = matcher.start(2) + offset + originalLength - 4;
            String image = "{{SharedImages/" + StringUtil.toLowerCase((String)sb.substring(imageStartPos, imageEndPos)) + "}}";
            int imageLength = image.length();
            image = image.replaceAll("\\[{2}", "");
            image = image.replaceAll("\\]{2}", "");
            sb.replace(matcher.start(0) + offset, matcher.start(0) + originalLength + offset, image);
            offset += "SharedImages".length() - prefixLength - (imageLength - image.length());
        }
        content = sb.toString();
        pattern = Pattern.compile("\\{\\|(.*?)\\|\\}", 32);
        matcher = pattern.matcher(content);
        sb = new StringBuffer(content);
        String mediaWikiTable = null;
        offset = 0;
        originalLength = 0;
        while (matcher.find()) {
            mediaWikiTable = sb.substring(matcher.start(1) + offset, matcher.end(1) + offset);
            originalLength = mediaWikiTable.length() + 4;
            mediaWikiTable = mediaWikiTable.replaceAll("class=(.*?)[|\n\r]", "");
            mediaWikiTable = mediaWikiTable.replaceAll("(\\|\\-)(.*)", "$1");
            mediaWikiTable = mediaWikiTable.replaceAll("\\|\\+(.*)", "===$1===");
            mediaWikiTable = mediaWikiTable.replaceAll("(?m)^!(.+)", "|=$1|");
            mediaWikiTable = mediaWikiTable.replaceAll("[\n\r]", "");
            mediaWikiTable = mediaWikiTable.replaceAll("\\|\\-", "\n\r");
            mediaWikiTable = mediaWikiTable.replaceAll("\\|\\|", "|");
            mediaWikiTable = mediaWikiTable.replaceAll("/{4}", "");
            sb.replace(matcher.start(0) + offset, matcher.start(0) + originalLength + offset, mediaWikiTable);
            offset += mediaWikiTable.length() - originalLength;
        }
        content = sb.toString();
        content = this.runRegexp(content, "/{2}(\\{{3})", "$1");
        content = this.runRegexp(content, "(\\}{3})/{2}", "$1");
        pattern = Pattern.compile("\\[{2}([^\\]]*)\\]{2}", 32);
        matcher = pattern.matcher(content);
        sb = new StringBuffer(content);
        while (matcher.find()) {
            String link = matcher.group(1).replace("_", " ");
            sb.replace(matcher.start(1), matcher.end(1), link);
        }
        return TABLE_OF_CONTENTS + super.postProcess(sb.toString());
    }
}

