/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl.checker;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.security.pacl.Reflection;
import com.liferay.portal.security.pacl.checker.BaseChecker;
import java.security.Permission;

public class SecurityChecker
extends BaseChecker {
    private static Log _log = LogFactoryUtil.getLog(SecurityChecker.class);

    @Override
    public void afterPropertiesSet() {
    }

    @Override
    public boolean implies(Permission permission) {
        String name = permission.getName();
        if (name.equals("getPolicy")) {
            if (!this.hasGetPolicy(permission)) {
                this.logSecurityException(_log, "Attempted to get the policy");
                return false;
            }
        } else if (name.equals("setPolicy")) {
            if (!this.hasSetPolicy(permission)) {
                this.logSecurityException(_log, "Attempted to set the policy");
                return false;
            }
        } else {
            if (_log.isDebugEnabled()) {
                Thread.dumpStack();
            }
            this.logSecurityException(_log, "Attempted to " + permission.getName() + " on " + permission.getActions());
            return false;
        }
        return true;
    }

    protected boolean hasGetPolicy(Permission permission) {
        int stackIndex = Reflection.getStackIndex(new int[]{11, 11}, new int[]{11, 10});
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        if (this.isTrustedCaller(callerClass, permission)) {
            return true;
        }
        this.logSecurityException(_log, "Attempted to get the policy");
        return false;
    }

    protected boolean hasSetPolicy(Permission permission) {
        int stackIndex = Reflection.getStackIndex(new int[]{11, 11}, new int[]{11, 10});
        Class<?> callerClass = Reflection.getCallerClass(stackIndex);
        if (this.isTrustedCaller(callerClass, permission)) {
            return true;
        }
        this.logSecurityException(_log, "Attempted to set the policy");
        return false;
    }
}

