/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.jena.util.Log;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.ResultSetStatementIterator;
import com.hp.hpl.mesa.rdf.jena.rdb.SQLCache;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DriverGenericAttribute
extends DriverGenericGeneric {
    protected Map attributeMap = new HashMap();
    protected int attributeIndexCount = 0;

    public DriverGenericAttribute() {
        this.LAYOUT_TYPE = "Attribute";
        this.DATABASE_TYPE = "Generic";
    }

    public void hintPropertyTable(Property property) throws RDFException {
        IDBID iDBID = this.addResource(property);
        Integer n = new Integer(this.attributeIndexCount++);
        this.attributeMap.put(iDBID.getID(), n);
        try {
            this.m_sql.flushPreparedStatementCache();
            Statement statement = this.getConnection().createStatement();
            Iterator iterator = this.m_sql.getSQLStatementGroup("createAttributeTable").iterator();
            while (iterator.hasNext()) {
                String string = SQLCache.substitute((String)iterator.next(), "${a}", n.toString());
                statement.executeUpdate(string);
            }
            statement.close();
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to create attributed table", (Exception)sQLException);
        }
    }

    public void addStatement(com.hp.hpl.mesa.rdf.jena.model.Statement statement, ModelRDB modelRDB) throws RDFException {
        if (!this.SKIP_DUPLICATE_CHECK && this.isStatementPresent(statement.getSubject(), statement.getPredicate(), statement.getObject(), modelRDB)) {
            return;
        }
        IDBID iDBID = this.addResource(statement.getPredicate());
        IDBID iDBID2 = this.addResource(statement.getSubject());
        RDFNode rDFNode = statement.getObject();
        IDBID iDBID3 = null;
        boolean bl = rDFNode instanceof Literal;
        iDBID3 = bl ? this.addLiteral((Literal)rDFNode) : this.addResource((Resource)rDFNode);
        try {
            Object[] objectArray = new Object[]{iDBID2.getID(), iDBID.getID(), iDBID3.getID(), new Short(bl ? (short)1 : 0), modelRDB.getDBID().getID()};
            this.m_sql.runSQLQuery(this.INSERT_BY_PROCEDURE ? "insertStatementProc" : "insertStatement", objectArray);
            Integer n = (Integer)this.attributeMap.get(iDBID.getID());
            if (n != null) {
                String string = "RDF_A_" + n;
                PreparedStatement preparedStatement = this.getConnection().prepareStatement("INSERT INTO " + string + "(SUBJECT, PREDICATE, OBJECT, OBJECT_ISLITERAL, MODEL) VALUES(?,?,?,?,?)");
                preparedStatement.setObject(1, iDBID2.getID());
                preparedStatement.setObject(2, iDBID.getID());
                preparedStatement.setObject(3, iDBID3.getID());
                preparedStatement.setInt(4, bl ? 1 : 0);
                preparedStatement.setObject(5, modelRDB.getDBID().getID());
                preparedStatement.executeUpdate();
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Failed to register statement", (Exception)sQLException);
        }
    }

    public ResultSetIterator listStatements(Resource resource, Property property, RDFNode rDFNode, ModelRDB modelRDB) throws RDFException {
        String string = "list";
        if (resource != null) {
            string = string + "S";
        }
        if (property != null) {
            string = string + "P";
        }
        if (rDFNode != null) {
            string = string + "O";
        }
        try {
            Integer n;
            Object[] objectArray;
            if (property != null && (objectArray = this.getResourceID(property)) != null && (n = (Integer)this.attributeMap.get(objectArray.getID())) != null) {
                IDBID iDBID;
                String string2 = "a" + string;
                int n2 = 1;
                String string3 = n.toString();
                PreparedStatement preparedStatement = this.m_sql.getPreparedSQLStatement(string2, string3);
                if (resource != null) {
                    iDBID = this.getResourceID(resource);
                    if (iDBID == null) {
                        return new ResultSetIterator();
                    }
                    preparedStatement.setObject(n2++, iDBID.getID());
                }
                preparedStatement.setObject(n2++, objectArray.getID());
                if (rDFNode != null) {
                    if (rDFNode instanceof Literal) {
                        iDBID = this.getLiteralID((Literal)rDFNode);
                        if (iDBID == null) {
                            return new ResultSetIterator();
                        }
                        preparedStatement.setObject(n2++, iDBID.getID());
                        preparedStatement.setInt(n2++, 1);
                    } else {
                        iDBID = this.getResourceID((Resource)rDFNode);
                        if (iDBID == null) {
                            return new ResultSetIterator();
                        }
                        preparedStatement.setObject(n2++, iDBID.getID());
                        preparedStatement.setInt(n2++, 0);
                    }
                }
                return this.m_sql.executeSQL(preparedStatement, string2 + string3, new ResultSetStatementIterator(modelRDB, this));
            }
            objectArray = this.statementArgs(resource, property, rDFNode, modelRDB);
            if (objectArray == null) {
                return new ResultSetIterator();
            }
            return this.m_sql.runSQLQuery(string, objectArray, new ResultSetStatementIterator(modelRDB, this));
        }
        catch (SQLException sQLException) {
            throw new RDFRDBException("Internal sql failure in " + string, (Exception)sQLException);
        }
    }

    public void cleanDB() {
        super.cleanDB();
        Iterator iterator = this.attributeMap.values().iterator();
        try {
            Statement statement = this.getConnection().createStatement();
            while (iterator.hasNext()) {
                Integer n = (Integer)iterator.next();
                try {
                    statement.executeUpdate("DROP TABLE RDF_A_" + n);
                }
                catch (SQLException sQLException) {
                    Log.warning("Problem cleaning DB: ", sQLException);
                }
            }
            statement.close();
        }
        catch (Exception exception) {
            Log.warning("Problem in DB access during clean up", exception);
        }
    }
}

