/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.buffer;

public class FastIntBuffer {
    private int[][] buffers = new int[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private int[] currentBuffer;
    private int offset;
    private int count;

    public FastIntBuffer() {
        this(1024);
    }

    public FastIntBuffer(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        this.needNewBuffer(size);
    }

    private void needNewBuffer(int newCount) {
        if (this.currentBufferIndex < this.buffersCount - 1) {
            this.offset = 0;
            ++this.currentBufferIndex;
            this.currentBuffer = this.buffers[this.currentBufferIndex];
        } else {
            int newBufferSize = this.currentBuffer == null ? newCount : Math.max(this.currentBuffer.length << 1, newCount - this.count);
            ++this.currentBufferIndex;
            this.currentBuffer = new int[newBufferSize];
            this.offset = 0;
            if (this.currentBufferIndex >= this.buffers.length) {
                int newLen = this.buffers.length << 1;
                int[][] newBuffers = new int[newLen][];
                System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
                this.buffers = newBuffers;
            }
            this.buffers[this.currentBufferIndex] = this.currentBuffer;
            ++this.buffersCount;
        }
    }

    public FastIntBuffer append(int[] array, int off, int len) {
        int end = off + len;
        if (off < 0 || off > array.length || len < 0 || end > array.length || end < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newCount = this.count + len;
        int remaining = len;
        while (remaining > 0) {
            int part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.count += part;
            if ((remaining -= part) <= 0) continue;
            this.needNewBuffer(newCount);
        }
        return this;
    }

    public FastIntBuffer append(int[] array) {
        return this.append(array, 0, array.length);
    }

    public FastIntBuffer append(int element) {
        if (this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.count + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.count;
        return this;
    }

    public FastIntBuffer append(FastIntBuffer buff) {
        for (int i = 0; i < buff.currentBufferIndex; ++i) {
            this.append(buff.buffers[i]);
        }
        this.append(buff.currentBuffer, 0, buff.offset);
        return this;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public int[] array(int index) {
        return this.buffers[index];
    }

    public void clear() {
        this.count = 0;
        this.offset = 0;
        this.currentBufferIndex = 0;
        this.currentBuffer = this.buffers[this.currentBufferIndex];
        this.buffersCount = 1;
    }

    public int[] toArray() {
        int remaining = this.count;
        int pos = 0;
        int[] array = new int[this.count];
        for (int[] buf : this.buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
        }
        return array;
    }

    public int[] toArray(int start, int len) {
        int remaining = len;
        int pos = 0;
        int[] array = new int[len];
        if (len == 0) {
            return array;
        }
        int i = 0;
        while (start >= this.buffers[i].length) {
            start -= this.buffers[i].length;
            ++i;
        }
        while (i < this.buffersCount) {
            int[] buf = this.buffers[i];
            int c = Math.min(buf.length - start, remaining);
            System.arraycopy(buf, start, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
            start = 0;
            ++i;
        }
        return array;
    }

    public int get(int index) {
        if (index >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        int[] b;
        while (index >= (b = this.buffers[ndx]).length) {
            ++ndx;
            index -= b.length;
        }
        return b[index];
    }
}

