/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.publisher.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.HostingNode;
import org.gcube.common.resources.gcore.Resource;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    public static String getCurrentVO(String currentScope) {
        ScopeBean scopeBean = new ScopeBean(currentScope);
        String currentVO = null;
        if (scopeBean.is(ScopeBean.Type.VRE)) {
            currentVO = scopeBean.enclosingScope().toString();
        } else if (scopeBean.is(ScopeBean.Type.VO)) {
            currentVO = currentScope;
        } else {
            return null;
        }
        return currentVO;
    }

    public static <T extends Resource> HashSet<String> getInternalVOScopes(T resource) {
        HashSet<String> vosScopes = new HashSet<String>();
        log.debug("checking and collect the internal VO scopes");
        for (String scope : resource.scopes()) {
            log.debug("processing scope: " + scope);
            ScopeBean scopeBean = new ScopeBean(scope);
            if (scopeBean.is(ScopeBean.Type.VRE)) {
                String enclosedVO = scopeBean.enclosingScope().toString();
                vosScopes.add(enclosedVO);
                log.debug(enclosedVO + " VO scope added");
                continue;
            }
            vosScopes.add(scope);
            log.debug(scope + " VO scope added");
        }
        return vosScopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GenericResource getGenericResourceByID(String id, String latestVO) {
        List resources;
        String currentScope = ScopeProvider.instance.get();
        try {
            ScopeProvider.instance.set(latestVO);
            XQuery query = ICFactory.queryFor(GenericResource.class);
            query.addCondition("$resource/ID/text() eq '" + id + "'");
            DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
            resources = client.submit((Query)query);
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        if (resources != null && !resources.isEmpty()) {
            return (GenericResource)resources.get(0);
        }
        log.info(" No resource found with id " + id + " in scope " + latestVO);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceEndpoint getServiceEndpointByID(String id, String latestVO) {
        List resources;
        String currentScope = ScopeProvider.instance.get();
        try {
            ScopeProvider.instance.set(latestVO);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/ID/text() eq '" + id + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            resources = client.submit((Query)query);
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        if (resources != null && !resources.isEmpty()) {
            return (ServiceEndpoint)resources.get(0);
        }
        log.info(" No resource found with id " + id + " in scope " + latestVO);
        return null;
    }

    public static <T extends Resource> List<String> getTimestamps(T resource) {
        XQuery query = Utils.getSpecificXQuery(resource);
        query.addCondition("$resource/ID/text() eq '" + resource.id() + "'");
        query.setResult("$resource/../../../../Document/LastUpdateMs/text()");
        DiscoveryClient client = ICFactory.client();
        List timestamps = client.submit((Query)query);
        return timestamps;
    }

    public static <T extends Resource> XQuery getSpecificXQuery(T resource) {
        XQuery query = null;
        if (resource.type().toString().equalsIgnoreCase("RuntimeResource")) {
            query = ICFactory.queryFor(ServiceEndpoint.class);
        } else if (resource.type().toString().equalsIgnoreCase("GenericResource")) {
            query = ICFactory.queryFor(GenericResource.class);
        } else if (resource.type().toString().equalsIgnoreCase("RunningInstance")) {
            query = ICFactory.queryFor(GCoreEndpoint.class);
        } else if (resource.type().toString().equalsIgnoreCase("GHN")) {
            query = ICFactory.queryFor(HostingNode.class);
        } else {
            throw new RuntimeException("The following resource type is not managed: " + resource);
        }
        return query;
    }

    public static <T extends Resource> List<String> setLatestInternalScopes(T resource, HashSet<String> vosScopes) {
        log.trace("setLatestInternalScopes method, voscopes " + vosScopes + ", resource id:  " + resource.id());
        String latestVO = Utils.getMoreRecentResourceVO(resource, vosScopes);
        if (latestVO != null) {
            return Utils.extractInternalScopes(resource, latestVO);
        }
        return null;
    }

    private static <T extends Resource> List<String> extractInternalScopes(T resource, String latestVO) {
        ServiceEndpoint extractedResource = null;
        log.debug("checking resource " + resource.id() + " type: " + resource.type());
        if (resource.type().toString().equalsIgnoreCase("RuntimeResource")) {
            extractedResource = Utils.getServiceEndpointByID(resource.id(), latestVO);
        } else if (resource.type().toString().equalsIgnoreCase("GenericResource")) {
            extractedResource = Utils.getGenericResourceByID(resource.id(), latestVO);
        } else {
            throw new RuntimeException("The following resource type is not managed: " + resource);
        }
        if (extractedResource.scopes().size() > 0) {
            ArrayList<String> scopesExtracted = new ArrayList<String>(extractedResource.scopes().size());
            for (String scope : extractedResource.scopes()) {
                scopesExtracted.add(scope);
            }
            return scopesExtracted;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T extends Resource> String getMoreRecentResourceVO(T resource, HashSet<String> vosScopes) {
        String currentScope = ScopeProvider.instance.get();
        long timestamp = 0L;
        long latestTimestamp = 0L;
        String latestVO = null;
        try {
            for (String voScope : vosScopes) {
                ScopeProvider.instance.set(voScope);
                log.debug("checking scope in " + voScope);
                List<String> timestamps = Utils.getTimestamps(resource);
                if (timestamps.isEmpty()) continue;
                timestamp = Long.parseLong(timestamps.get(0).toString());
                log.debug("checking " + voScope + " timestamp: " + timestamp + ", with the more recent timestamp: " + latestTimestamp);
                if (timestamp <= latestTimestamp) continue;
                latestTimestamp = timestamp;
                latestVO = voScope;
                log.debug("new timestamp is " + timestamp);
            }
        }
        finally {
            ScopeProvider.instance.set(currentScope);
        }
        log.debug("the vo with latest timestamp is " + latestVO);
        log.debug("timestamp is " + latestTimestamp);
        return latestVO;
    }
}

