/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.event.publisher;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Function;
import org.gcube.event.publisher.AbstractEventPublisher;
import org.gcube.event.publisher.Event;
import org.gcube.event.publisher.EventProcessorException;
import org.gcube.event.publisher.EventSender;
import org.gcube.event.publisher.EventStatus;
import org.gcube.event.publisher.HTTPWithOIDCAuthEventSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BufferedEventProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BufferedEventProcessor.class);
    private static final int DEFAULT_BUFFER_SIZE = 10;
    private static final int RESULT_POLLING_INTERVAL = 500;
    private ArrayBlockingQueue<Event> eventsBuffer;
    private Map<Runnable, Boolean> threadStatus;
    private int count = 0;
    private long min = 10000000000L;
    private long max = 0L;
    private int errors = 0;

    public BufferedEventProcessor(String conductorEndpoint, String clientId, String clientSecret, String keycloakTokenEndpoint, Function<Event, String> logInfoGenerator) throws EventProcessorException {
        this(conductorEndpoint, clientId, clientSecret, keycloakTokenEndpoint, logInfoGenerator, 10);
    }

    public BufferedEventProcessor(final String conductorEndpoint, final String clientId, final String clientSecret, final String keycloakTokenEndpoint, final Function<Event, String> logInfoGenerator, int bufferSize) throws EventProcessorException {
        this.eventsBuffer = new ArrayBlockingQueue(bufferSize, true);
        this.threadStatus = Collections.synchronizedMap(new HashMap(bufferSize));
        final AbstractEventPublisher publisher = new AbstractEventPublisher(){

            @Override
            protected EventSender createEventSender() {
                try {
                    return new HTTPWithOIDCAuthEventSender(new URL(conductorEndpoint), clientId, clientSecret, new URL(keycloakTokenEndpoint));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        };
        if (publisher.getEventSender() == null) {
            throw new EventProcessorException("Cannot create procrssor correctly");
        }
        for (int i = 0; i < bufferSize; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        EventStatus eventStatus;
                        Event toBeSent;
                        String log = null;
                        try {
                            toBeSent = (Event)((Object)BufferedEventProcessor.this.eventsBuffer.take());
                        }
                        catch (InterruptedException e) {
                            continue;
                        }
                        long start = System.currentTimeMillis();
                        BufferedEventProcessor.this.threadStatus.put(this, Boolean.TRUE);
                        logger.trace(" * Peeked event. Buffer size: {}", (Object)BufferedEventProcessor.this.eventsBuffer.size());
                        log = (String)logInfoGenerator.apply(toBeSent);
                        logger.debug(" > Sending event for: {}", (Object)log);
                        boolean sent = false;
                        String workflowId = null;
                        do {
                            try {
                                workflowId = publisher.publish(toBeSent, true);
                                sent = true;
                            }
                            catch (Exception e) {
                                logger.warn("Publishing event for {}. It will be re-published", (Object)log, (Object)e);
                            }
                        } while (!sent);
                        do {
                            eventStatus = null;
                            try {
                                Thread.sleep(500L);
                                eventStatus = publisher.check(workflowId);
                            }
                            catch (Exception e) {
                                logger.warn("Checking status for the event for {}", (Object)log, (Object)e);
                            }
                            if (eventStatus != null && eventStatus.getStatus() != null) continue;
                        } while (eventStatus.getStatus() != EventStatus.Status.COMPLETED && eventStatus.getStatus() != EventStatus.Status.FAILED);
                        long elapsed = System.currentTimeMillis() - start;
                        BufferedEventProcessor.this.count = BufferedEventProcessor.this.count + 1;
                        if (elapsed > BufferedEventProcessor.this.max) {
                            BufferedEventProcessor.this.max = elapsed;
                        }
                        if (elapsed < BufferedEventProcessor.this.min) {
                            BufferedEventProcessor.this.min = elapsed;
                        }
                        if (eventStatus.getStatus() == EventStatus.Status.FAILED) {
                            logger.warn(" - ({}) {} -> {} [{} ms]", new Object[]{BufferedEventProcessor.this.count, log, eventStatus.getStatus(), elapsed});
                            BufferedEventProcessor.this.errors += 1;
                        } else {
                            logger.info(" - (" + BufferedEventProcessor.this.count + ") " + log + " -> " + (Object)((Object)eventStatus.getStatus()) + " [" + elapsed + " ms]");
                        }
                        BufferedEventProcessor.this.threadStatus.put(this, Boolean.FALSE);
                    }
                }
            });
            this.threadStatus.put(t, Boolean.FALSE);
            t.start();
        }
    }

    public void enqueueEvent(Event event) throws InterruptedException {
        this.eventsBuffer.put(event);
    }

    public Boolean allQueuedFinishedCorrectly() {
        return this.eventsBuffer.size() > 0 || this.threadStatus.values().stream().anyMatch(v -> v.equals(Boolean.TRUE));
    }

    public int getCount() {
        return this.count;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public int getErrors() {
        return this.errors;
    }
}

