/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.delegates;

import org.gcube.common.clients.Call;
import org.gcube.common.clients.config.EndpointConfig;
import org.gcube.common.clients.config.ProxyConfig;
import org.gcube.common.clients.delegates.AbstractDelegate;
import org.gcube.common.clients.delegates.ProxyDelegate;
import org.gcube.common.clients.delegates.ProxyPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DirectDelegate<A, S>
extends AbstractDelegate<A, S, EndpointConfig<A, S>>
implements ProxyDelegate<S> {
    private static Logger log = LoggerFactory.getLogger(DirectDelegate.class);

    public DirectDelegate(EndpointConfig<A, S> config) {
        super(config);
    }

    @Override
    public <V> V make(Call<S, V> call) throws Exception {
        ProxyPlugin plugin = ((EndpointConfig)this.config()).plugin();
        Object address = ((EndpointConfig)this.config()).address();
        log.info("calling {} @ {}", (Object)plugin.name(), address);
        Object stub = null;
        try {
            stub = plugin.resolve(address, (ProxyConfig<?, ?>)this.config());
        }
        catch (Exception e) {
            throw new IllegalStateException("could not resolve " + address, e);
        }
        try {
            return call.call(stub);
        }
        catch (Exception fault) {
            throw plugin.convert(fault, (ProxyConfig<?, ?>)this.config());
        }
    }
}

