/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.io.delta;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class ByteChannelWriter {
    private ByteBuffer _byteBuffer;
    private final WritableByteChannel _writableByteChannel;

    public ByteChannelWriter(WritableByteChannel writableByteChannel) {
        this(writableByteChannel, 1024);
    }

    public ByteChannelWriter(WritableByteChannel writableByteChannel, int bufferLength) {
        this._writableByteChannel = writableByteChannel;
        this._byteBuffer = ByteBuffer.allocate(bufferLength);
    }

    public void ensureSpace(int length) throws IOException {
        if (this._byteBuffer.remaining() < length) {
            this.write();
        }
    }

    public void finish() throws IOException {
        this._byteBuffer.flip();
        this._writableByteChannel.write(this._byteBuffer);
    }

    public ByteBuffer getBuffer() {
        return this._byteBuffer;
    }

    public void resizeBuffer(int minBufferLength) {
        if (this._byteBuffer.capacity() >= minBufferLength) {
            return;
        }
        ByteBuffer newBuffer = ByteBuffer.allocate(minBufferLength);
        this._byteBuffer.flip();
        newBuffer.put(this._byteBuffer);
        this._byteBuffer = newBuffer;
    }

    protected void write() throws IOException {
        this._byteBuffer.flip();
        this._writableByteChannel.write(this._byteBuffer);
        this._byteBuffer.clear();
    }
}

