/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.diff;

import com.ecyrd.jspwiki.NoRequiredPropertyException;
import com.ecyrd.jspwiki.TextUtil;
import com.ecyrd.jspwiki.WikiContext;
import com.ecyrd.jspwiki.WikiEngine;
import com.ecyrd.jspwiki.diff.DiffProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.jrcs.diff.AddDelta;
import org.apache.commons.jrcs.diff.ChangeDelta;
import org.apache.commons.jrcs.diff.Chunk;
import org.apache.commons.jrcs.diff.DeleteDelta;
import org.apache.commons.jrcs.diff.Delta;
import org.apache.commons.jrcs.diff.Diff;
import org.apache.commons.jrcs.diff.DiffAlgorithm;
import org.apache.commons.jrcs.diff.DifferentiationFailedException;
import org.apache.commons.jrcs.diff.Revision;
import org.apache.commons.jrcs.diff.RevisionVisitor;
import org.apache.commons.jrcs.diff.myers.MyersDiff;
import org.apache.log4j.Logger;

public class ContextualDiffProvider
implements DiffProvider {
    private static final Logger log = Logger.getLogger(ContextualDiffProvider.class);
    public static final String PROP_UNCHANGED_CONTEXT_LIMIT = "jspwiki.contextualDiffProvider.unchangedContextLimit";
    public boolean m_emitChangeNextPreviousHyperlinks = true;
    public String m_changeStartHtml = "";
    public String m_changeEndHtml = "";
    public String m_diffStart = "<div class=\"diff-wikitext\">";
    public String m_diffEnd = "</div>";
    public String m_insertionStartHtml = "<font color=\"#8000FF\"><span class=\"diff-insertion\">";
    public String m_insertionEndHtml = "</span></font>";
    public String m_deletionStartHtml = "<strike><font color=\"red\"><span class=\"diff-deletion\">";
    public String m_deletionEndHtml = "</span></font></strike>";
    private String m_anchorPreIndex = "<a name=\"change-";
    private String m_anchorPostIndex = "\" />";
    private String m_backPreIndex = "<a class=\"diff-nextprev\" title=\"Go to previous change\" href=\"#change-";
    private String m_backPostIndex = "\">&lt;&lt;</a>";
    private String m_forwardPreIndex = "<a class=\"diff-nextprev\" title=\"Go to next change\" href=\"#change-";
    private String m_forwardPostIndex = "\">&gt;&gt;</a>";
    public String m_elidedHeadIndicatorHtml = "<br/><br/><b>...</b>";
    public String m_elidedTailIndicatorHtml = "<b>...</b><br/><br/>";
    public String m_lineBreakHtml = "<br />";
    public String m_alternatingSpaceHtml = "&nbsp;";
    private static final int LIMIT_MAX_VALUE = 0x3FFFFFFE;
    private int m_unchangedContextLimit = 0x3FFFFFFE;

    public String getProviderInfo() {
        return "ContextualDiffProvider";
    }

    public void initialize(WikiEngine engine, Properties properties) throws NoRequiredPropertyException, IOException {
        String configuredLimit = properties.getProperty(PROP_UNCHANGED_CONTEXT_LIMIT, Integer.toString(0x3FFFFFFE));
        int limit = 0x3FFFFFFE;
        try {
            limit = Integer.parseInt(configuredLimit);
        }
        catch (NumberFormatException e) {
            log.warn((Object)("Failed to parseInt jspwiki.contextualDiffProvider.unchangedContextLimit=" + configuredLimit + "   Will use a huge number as limit."), (Throwable)e);
        }
        this.m_unchangedContextLimit = limit;
    }

    public synchronized String makeDiffHtml(WikiContext ctx, String wikiOld, String wikiNew) {
        Object[] alpha = this.sequence(TextUtil.replaceEntities(wikiOld));
        Object[] beta = this.sequence(TextUtil.replaceEntities(wikiNew));
        Revision rev = null;
        try {
            rev = Diff.diff((Object[])alpha, (Object[])beta, (DiffAlgorithm)new MyersDiff());
        }
        catch (DifferentiationFailedException dfe) {
            log.error((Object)"Diff generation failed", (Throwable)dfe);
            return "Error while creating version diff.";
        }
        int revSize = rev.size();
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_diffStart);
        ChangeMerger cm = new ChangeMerger(sb, (String[])alpha, revSize);
        rev.accept((RevisionVisitor)cm);
        cm.shutdown();
        sb.append(this.m_diffEnd);
        return sb.toString();
    }

    private String[] sequence(String wikiText) {
        String[] linesArray = Diff.stringToArray((String)wikiText);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < linesArray.length; ++i) {
            String line = linesArray[i];
            String lastToken = null;
            String token = null;
            StringTokenizer st = new StringTokenizer(line, " ", true);
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                if (" ".equals(lastToken) && " ".equals(token)) {
                    token = this.m_alternatingSpaceHtml;
                }
                list.add(token);
                lastToken = token;
            }
            list.add(this.m_lineBreakHtml);
        }
        return list.toArray(new String[0]);
    }

    private final class ChangeMerger
    implements RevisionVisitor {
        private StringBuffer m_sb = null;
        private int m_max = -1;
        private int m_index = 0;
        private int m_firstElem = 0;
        private int m_count = 1;
        private int m_mode = -1;
        private StringBuffer m_origBuf = null;
        private StringBuffer m_newBuf = null;
        private String[] m_origStrings = null;

        private ChangeMerger(StringBuffer sb, String[] origStrings, int max) {
            this.m_sb = sb;
            this.m_origStrings = origStrings;
            this.m_max = max;
            this.m_origBuf = new StringBuffer();
            this.m_newBuf = new StringBuffer();
        }

        private void updateState(Delta delta) {
            ++this.m_index;
            Chunk orig = delta.getOriginal();
            if (orig.first() > this.m_firstElem) {
                this.flushChanges();
                if (orig.first() - this.m_firstElem > 2 * ContextualDiffProvider.this.m_unchangedContextLimit) {
                    int startIndex;
                    int j;
                    if (this.m_firstElem > 0) {
                        int endIndex = Math.min(this.m_firstElem + ContextualDiffProvider.this.m_unchangedContextLimit, this.m_origStrings.length - 1);
                        for (j = this.m_firstElem; j < endIndex; ++j) {
                            this.m_sb.append(this.m_origStrings[j]);
                        }
                        this.m_sb.append(ContextualDiffProvider.this.m_elidedTailIndicatorHtml);
                    }
                    this.m_sb.append(ContextualDiffProvider.this.m_elidedHeadIndicatorHtml);
                    for (j = startIndex = Math.max(orig.first() - ContextualDiffProvider.this.m_unchangedContextLimit, 0); j < orig.first(); ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                } else {
                    for (int j = this.m_firstElem; j < orig.first(); ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                }
            }
            this.m_firstElem = orig.last() + 1;
        }

        public void visit(Revision rev) {
        }

        public void visit(AddDelta delta) {
            this.updateState((Delta)delta);
            if (this.m_mode == 1) {
                this.flushChanges();
                this.m_mode = -1;
            }
            if (this.m_mode == -1) {
                this.m_mode = 0;
            }
            if (this.m_mode == 0 || this.m_mode == 2) {
                this.addNew(delta.getRevised());
                this.m_mode = 1;
            }
        }

        public void visit(ChangeDelta delta) {
            this.updateState((Delta)delta);
            if (this.m_mode == -1) {
                this.m_mode = 2;
            }
            this.addOrig(delta.getOriginal());
            this.addNew(delta.getRevised());
        }

        public void visit(DeleteDelta delta) {
            this.updateState((Delta)delta);
            if (this.m_mode == 0) {
                this.flushChanges();
                this.m_mode = -1;
            }
            if (this.m_mode == -1) {
                this.m_mode = 1;
            }
            if (this.m_mode == 1 || this.m_mode == 2) {
                this.addOrig(delta.getOriginal());
                this.m_mode = 1;
            }
        }

        public void shutdown() {
            this.m_index = this.m_max + 1;
            this.flushChanges();
            if (this.m_firstElem < this.m_origStrings.length) {
                if (this.m_origStrings.length - this.m_firstElem > ContextualDiffProvider.this.m_unchangedContextLimit) {
                    int endIndex = Math.min(this.m_firstElem + ContextualDiffProvider.this.m_unchangedContextLimit, this.m_origStrings.length - 1);
                    for (int j = this.m_firstElem; j < endIndex; ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                    this.m_sb.append(ContextualDiffProvider.this.m_elidedTailIndicatorHtml);
                } else {
                    for (int j = this.m_firstElem; j < this.m_origStrings.length; ++j) {
                        this.m_sb.append(this.m_origStrings[j]);
                    }
                }
            }
        }

        private void addOrig(Chunk chunk) {
            if (chunk != null) {
                chunk.toString(this.m_origBuf);
            }
        }

        private void addNew(Chunk chunk) {
            if (chunk != null) {
                chunk.toString(this.m_newBuf);
            }
        }

        private void flushChanges() {
            if (this.m_newBuf.length() + this.m_origBuf.length() > 0) {
                this.m_sb.append(ContextualDiffProvider.this.m_changeStartHtml);
                if (ContextualDiffProvider.this.m_emitChangeNextPreviousHyperlinks && this.m_count > 1) {
                    this.m_sb.append(ContextualDiffProvider.this.m_backPreIndex);
                    this.m_sb.append(this.m_count - 1);
                    this.m_sb.append(ContextualDiffProvider.this.m_backPostIndex);
                }
                if (ContextualDiffProvider.this.m_emitChangeNextPreviousHyperlinks) {
                    this.m_sb.append(ContextualDiffProvider.this.m_anchorPreIndex);
                    this.m_sb.append(this.m_count++);
                    this.m_sb.append(ContextualDiffProvider.this.m_anchorPostIndex);
                }
                if (this.m_newBuf.length() > 0) {
                    this.m_sb.append(ContextualDiffProvider.this.m_insertionStartHtml);
                    this.m_sb.append(this.m_newBuf);
                    this.m_sb.append(ContextualDiffProvider.this.m_insertionEndHtml);
                }
                if (this.m_origBuf.length() > 0) {
                    this.m_sb.append(ContextualDiffProvider.this.m_deletionStartHtml);
                    this.m_sb.append(this.m_origBuf);
                    this.m_sb.append(ContextualDiffProvider.this.m_deletionEndHtml);
                }
                if (ContextualDiffProvider.this.m_emitChangeNextPreviousHyperlinks && this.m_index < this.m_max) {
                    this.m_sb.append(ContextualDiffProvider.this.m_forwardPreIndex);
                    this.m_sb.append(this.m_count);
                    this.m_sb.append(ContextualDiffProvider.this.m_forwardPostIndex);
                }
                this.m_sb.append(ContextualDiffProvider.this.m_changeEndHtml);
                this.m_origBuf = new StringBuffer();
                this.m_newBuf = new StringBuffer();
            }
            this.m_mode = -1;
        }
    }
}

