/*
 * Decompiled with CFR 0.152.
 */
package com.ecyrd.jspwiki.tags;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.tagext.TagSupport;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CookieTag
extends TagSupport {
    private static final long serialVersionUID = 0L;
    private static Logger log = Logger.getLogger(CookieTag.class);
    private String m_name;
    private String m_item;
    private String m_value;
    private String m_var;
    private String m_scope;
    private String m_clear;

    public void setName(String s) {
        this.m_name = s;
    }

    public void setItem(String s) {
        this.m_item = s;
    }

    public void setValue(String s) {
        this.m_value = s;
    }

    public void setVar(String s) {
        this.m_scope = s;
    }

    public void setClear(String s) {
        this.m_clear = s;
    }

    public void setScope(String s) {
        this.m_scope = s;
    }

    public void release() {
        this.m_scope = null;
        this.m_clear = null;
        this.m_value = null;
        this.m_var = null;
        this.m_item = null;
        this.m_name = null;
        super.release();
    }

    private int getScope(String s) {
        if (s == null) {
            return 2;
        }
        if ("page".equals(this.m_scope)) {
            return 1;
        }
        if ("session".equals(this.m_scope)) {
            return 3;
        }
        if ("application".equals(this.m_scope)) {
            return 4;
        }
        return 2;
    }

    public int doEndTag() {
        String out = null;
        Cookie cookie = this.findCookie(this.m_name);
        boolean changed = false;
        if (this.m_value != null) {
            if (this.m_item != null) {
                this.setItemValue(cookie, this.m_item, this.m_value);
            } else {
                cookie.setValue(this.m_value);
            }
            changed = true;
        } else {
            out = this.m_item != null ? this.getItemValue(cookie, this.m_item) : cookie.getValue();
        }
        if (out != null) {
            if (this.m_var != null) {
                int scope = this.getScope(this.m_scope);
                this.pageContext.setAttribute(this.m_var, (Object)out, scope);
            } else {
                try {
                    this.pageContext.getOut().print(out);
                }
                catch (IOException ioe) {
                    log.warn((Object)("Failed to write to JSP page: " + ioe.getMessage()), (Throwable)ioe);
                }
            }
        }
        Cookie cleared = null;
        if (this.m_clear != null) {
            cleared = this.findCookie(this.m_clear);
            if (this.m_item != null) {
                this.setItemValue(cookie, this.m_item, null);
            } else {
                cleared.setValue(null);
            }
        }
        HttpServletResponse res = (HttpServletResponse)this.pageContext.getResponse();
        if (changed) {
            res.addCookie(cookie);
        }
        if (cleared != null) {
            res.addCookie(cleared);
        }
        return 6;
    }

    private void setItemValue(Cookie c, String item, String value) {
        if (c == null) {
            return;
        }
        String in = c.getValue();
        Map<String, String> values = this.parseCookieValues(in);
        values.put(item, value);
        String cv = this.encodeValues(values);
        c.setValue(cv);
    }

    private String getItemValue(Cookie c, String item) {
        if (c == null || item == null) {
            return null;
        }
        String in = c.getValue();
        Map<String, String> values = this.parseCookieValues(in);
        return values.get(item);
    }

    private Map<String, String> parseCookieValues(String s) {
        HashMap<String, String> rval = new HashMap<String, String>();
        if (s == null) {
            return rval;
        }
        String[] nvps = s.split("&");
        if (nvps == null) {
            return rval;
        }
        for (int i = 0; i < nvps.length; ++i) {
            String nvp = this.decode(nvps[i]);
            String[] nv = nvp.split("=");
            if (nv[0] == null || nv[0].trim().length() <= 0) continue;
            rval.put(nv[0], nv[1]);
        }
        return rval;
    }

    private String encodeValues(Map values) {
        StringBuffer rval = new StringBuffer();
        if (values == null || values.size() == 0) {
            return rval.toString();
        }
        for (Map.Entry e : values.entrySet()) {
            String n = (String)e.getKey();
            String v = (String)e.getValue();
            if (v == null) continue;
            String nv = n + "=" + v;
            rval.append(this.encode(nv));
        }
        return rval.toString();
    }

    private String encode(String nvp) {
        String coded = "";
        try {
            coded = URLEncoder.encode(nvp, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.info((Object)"Failed to encode UTF-8", (Throwable)e);
        }
        return coded.replaceAll("\\+", "%20");
    }

    private String decode(String envp) {
        try {
            String rval = URLDecoder.decode(envp, "UTF-8");
            return rval;
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Failed to decode cookie", (Throwable)e);
            return envp;
        }
    }

    private Cookie findCookie(String cname) {
        Cookie[] cookies;
        HttpServletRequest req = (HttpServletRequest)this.pageContext.getRequest();
        if (req != null && (cookies = req.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(cname)) continue;
                return cookies[i];
            }
        }
        return new Cookie(cname, null);
    }
}

