/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.outerj.daisy.diff.output.TextDiffOutput;
import org.outerj.daisy.diff.output.TextDiffer;
import org.outerj.daisy.diff.tag.ArgumentComparator;
import org.outerj.daisy.diff.tag.DelimiterAtom;
import org.outerj.daisy.diff.tag.IAtomSplitter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagDiffer
implements TextDiffer {
    private TextDiffOutput output;

    public TagDiffer(TextDiffOutput textDiffOutput) {
        this.output = textDiffOutput;
    }

    @Override
    public void diff(IAtomSplitter iAtomSplitter, IAtomSplitter iAtomSplitter2) throws Exception {
        RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(iAtomSplitter, iAtomSplitter2);
        List<RangeDifference> list = this.preProcess(rangeDifferenceArray, iAtomSplitter);
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < list.size(); ++i) {
            this.parseNoChange(n2, list.get(i).leftStart(), n, list.get(i).rightStart(), iAtomSplitter, iAtomSplitter2);
            String string = iAtomSplitter.substring(list.get(i).leftStart(), list.get(i).leftEnd());
            String string2 = iAtomSplitter2.substring(list.get(i).rightStart(), list.get(i).rightEnd());
            if (list.get(i).leftLength() > 0) {
                this.output.addRemovedPart(string);
            }
            if (list.get(i).rightLength() > 0) {
                this.output.addAddedPart(string2);
            }
            n = list.get(i).rightEnd();
            n2 = list.get(i).leftEnd();
        }
        if (n < iAtomSplitter2.getRangeCount()) {
            this.parseNoChange(n2, iAtomSplitter.getRangeCount(), n, iAtomSplitter2.getRangeCount(), iAtomSplitter, iAtomSplitter2);
        }
    }

    private void parseNoChange(int n, int n2, int n3, int n4, IAtomSplitter iAtomSplitter, IAtomSplitter iAtomSplitter2) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        while (n < n2) {
            while (n < n2 && !iAtomSplitter2.getAtom(n3).hasInternalIdentifiers() && !iAtomSplitter.getAtom(n).hasInternalIdentifiers()) {
                stringBuilder.append(iAtomSplitter2.getAtom(n3).getFullText());
                ++n3;
                ++n;
            }
            if (stringBuilder.length() > 0) {
                this.output.addClearPart(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
            if (n >= n2) continue;
            ArgumentComparator argumentComparator = new ArgumentComparator(iAtomSplitter.getAtom(n).getFullText());
            ArgumentComparator argumentComparator2 = new ArgumentComparator(iAtomSplitter2.getAtom(n3).getFullText());
            RangeDifference[] rangeDifferenceArray = RangeDifferencer.findDifferences(argumentComparator, argumentComparator2);
            List<RangeDifference> list = this.preProcess(rangeDifferenceArray, 2);
            int n5 = 0;
            for (int i = 0; i < list.size(); ++i) {
                if (n5 < list.get(i).rightStart()) {
                    this.output.addClearPart(argumentComparator2.substring(n5, list.get(i).rightStart()));
                }
                if (list.get(i).leftLength() > 0) {
                    this.output.addRemovedPart(argumentComparator.substring(list.get(i).leftStart(), list.get(i).leftEnd()));
                }
                if (list.get(i).rightLength() > 0) {
                    this.output.addAddedPart(argumentComparator2.substring(list.get(i).rightStart(), list.get(i).rightEnd()));
                }
                n5 = list.get(i).rightEnd();
            }
            if (n5 < argumentComparator2.getRangeCount()) {
                this.output.addClearPart(argumentComparator2.substring(n5));
            }
            ++n;
            ++n3;
        }
    }

    private List<RangeDifference> preProcess(RangeDifference[] rangeDifferenceArray, IAtomSplitter iAtomSplitter) {
        LinkedList<RangeDifference> linkedList = new LinkedList<RangeDifference>();
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            int n = rangeDifferenceArray[i].leftStart();
            int n2 = rangeDifferenceArray[i].leftEnd();
            int n3 = rangeDifferenceArray[i].rightStart();
            int n4 = rangeDifferenceArray[i].rightEnd();
            int n5 = rangeDifferenceArray[i].kind();
            int n6 = n2;
            boolean bl = true;
            while (bl && i + 1 < rangeDifferenceArray.length && rangeDifferenceArray[i + 1].kind() == n5) {
                int n7 = 0;
                int n8 = Math.max(n2 - n, n4 - n3);
                if (n8 > 5) {
                    n7 = n8 > 10 ? 3 : 2;
                }
                while (n6 < rangeDifferenceArray[i + 1].leftStart() && (iAtomSplitter.getAtom(n6) instanceof DelimiterAtom || n7-- > 0)) {
                    ++n6;
                }
                if (n6 == rangeDifferenceArray[i + 1].leftStart()) {
                    n2 = rangeDifferenceArray[i + 1].leftEnd();
                    n4 = rangeDifferenceArray[i + 1].rightEnd();
                    n6 = n2;
                    ++i;
                    continue;
                }
                bl = false;
                if (iAtomSplitter.getAtom(n6) instanceof DelimiterAtom || !iAtomSplitter.getAtom(n6).getFullText().equals(" ")) continue;
                throw new IllegalStateException("space found aiaiai");
            }
            linkedList.add(new RangeDifference(n5, n3, n4 - n3, n, n2 - n));
        }
        return linkedList;
    }

    private List<RangeDifference> preProcess(RangeDifference[] rangeDifferenceArray, int n) {
        LinkedList<RangeDifference> linkedList = new LinkedList<RangeDifference>();
        for (int i = 0; i < rangeDifferenceArray.length; ++i) {
            int n2 = rangeDifferenceArray[i].leftStart();
            int n3 = rangeDifferenceArray[i].leftEnd();
            int n4 = rangeDifferenceArray[i].rightStart();
            int n5 = rangeDifferenceArray[i].rightEnd();
            int n6 = rangeDifferenceArray[i].kind();
            while (i + 1 < rangeDifferenceArray.length && rangeDifferenceArray[i + 1].kind() == n6 && rangeDifferenceArray[i + 1].leftStart() <= n3 + n && rangeDifferenceArray[i + 1].rightStart() <= n5 + n) {
                n3 = rangeDifferenceArray[i + 1].leftEnd();
                n5 = rangeDifferenceArray[i + 1].rightEnd();
                ++i;
            }
            linkedList.add(new RangeDifference(n6, n4, n5 - n4, n2, n3 - n2));
        }
        return linkedList;
    }
}

