/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.PortletException;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.BridgeAuthenticator;
import org.portletbridge.portlet.BridgeRequest;
import org.portletbridge.portlet.BridgeTransformer;
import org.portletbridge.portlet.DefaultPortletBridgeMemento;
import org.portletbridge.portlet.HttpClientCallback;
import org.portletbridge.portlet.HttpClientTemplate;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeContent;
import org.portletbridge.portlet.PortletBridgeMemento;

public class BridgeViewPortlet
extends GenericPortlet {
    private static final Log log = LogFactory.getLog((Class)(class$org$portletbridge$portlet$BridgeViewPortlet == null ? (class$org$portletbridge$portlet$BridgeViewPortlet = BridgeViewPortlet.class$("org.portletbridge.portlet.BridgeViewPortlet")) : class$org$portletbridge$portlet$BridgeViewPortlet));
    private String mementoSessionKey = null;
    private HttpClientTemplate httpClientTemplate = null;
    private BridgeTransformer transformer = null;
    private String idParamKey = "id";
    private BridgeAuthenticator bridgeAuthenticator = null;
    static /* synthetic */ Class class$org$portletbridge$portlet$BridgeViewPortlet;

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
    }

    public void doView(final RenderRequest request, final RenderResponse response) throws PortletException, IOException {
        ResourceBundle resourceBundle = this.getPortletConfig().getResourceBundle(request.getLocale());
        if (request.getWindowState().equals((Object)WindowState.MINIMIZED)) {
            return;
        }
        response.setContentType("text/html");
        try {
            BridgeRequest bridgeRequest;
            PortletSession session = request.getPortletSession();
            PortletPreferences preferences = request.getPreferences();
            String portletId = response.getNamespace();
            PortletBridgeMemento tempMemento = (PortletBridgeMemento)session.getAttribute(this.mementoSessionKey, 1);
            if (tempMemento == null) {
                tempMemento = new DefaultPortletBridgeMemento(this.idParamKey, this.bridgeAuthenticator);
                session.setAttribute(this.mementoSessionKey, (Object)tempMemento, 1);
            }
            final PortletBridgeMemento memento = tempMemento;
            final PerPortletMemento perPortletMemento = memento.getPerPortletMemento(portletId);
            perPortletMemento.setPreferences(request);
            String urlId = request.getParameter(this.idParamKey);
            if (urlId != null) {
                bridgeRequest = memento.getBridgeRequest(urlId);
            } else {
                log.warn((Object)("no bridge request found for " + urlId));
                bridgeRequest = null;
            }
            if (urlId == null || bridgeRequest == null) {
                final URI initUrl = perPortletMemento.getInitUrl();
                this.httpClientTemplate.service((HttpMethodBase)new GetMethod(initUrl.toString()), perPortletMemento, new HttpClientCallback(){

                    public Object doInHttpClient(int statusCode, HttpMethodBase method) throws Throwable {
                        BridgeViewPortlet.this.transformer.transform(memento, perPortletMemento, initUrl, request, response, new InputStreamReader(method.getResponseBodyAsStream(), method.getResponseCharSet()));
                        return null;
                    }
                });
            } else {
                PortletBridgeContent content = perPortletMemento.dequeueContent(bridgeRequest.getId());
                if (content == null) {
                    this.httpClientTemplate.service((HttpMethodBase)new GetMethod(bridgeRequest.getUrl().toString()), perPortletMemento, new HttpClientCallback(){

                        public Object doInHttpClient(int statusCode, HttpMethodBase method) throws Throwable {
                            BridgeViewPortlet.this.transformer.transform(memento, perPortletMemento, bridgeRequest.getUrl(), request, response, new InputStreamReader(method.getResponseBodyAsStream(), method.getResponseCharSet()));
                            return null;
                        }
                    });
                } else {
                    this.transformer.transform(memento, perPortletMemento, bridgeRequest.getUrl(), request, response, new StringReader(content.getContent()));
                }
            }
        }
        catch (ResourceException resourceException) {
            String format = MessageFormat.format(resourceBundle.getString(resourceException.getMessage()), resourceException.getArgs());
            throw new PortletException(format, resourceException.getCause());
        }
    }

    public void destroy() {
        super.destroy();
    }

    public void setHttpClientTemplate(HttpClientTemplate httpClientTemplate) {
        this.httpClientTemplate = httpClientTemplate;
    }

    public void setTransformer(BridgeTransformer transformer) {
        this.transformer = transformer;
    }

    public void setMementoSessionKey(String mementoSessionKey) {
        this.mementoSessionKey = mementoSessionKey;
    }

    public void setIdParamKey(String idParamKey) {
        this.idParamKey = idParamKey;
    }

    public void setBridgeAuthenticator(BridgeAuthenticator bridgeAuthenticator) {
        this.bridgeAuthenticator = bridgeAuthenticator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

