/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.BridgeFunctions;
import org.portletbridge.portlet.BridgeFunctionsFactory;
import org.portletbridge.portlet.BridgeTransformer;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeMemento;
import org.portletbridge.portlet.TemplateFactory;
import org.portletbridge.xsl.XslFilter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DefaultBridgeTransformer
implements BridgeTransformer {
    private TemplateFactory templateFactory = null;
    private XMLReader parser;
    private String servletName;
    private final BridgeFunctionsFactory bridgeFunctionsFactory;

    public DefaultBridgeTransformer(BridgeFunctionsFactory bridgeFunctionsFactory, TemplateFactory templateFactory, XMLReader parser, String servletName) {
        this.bridgeFunctionsFactory = bridgeFunctionsFactory;
        this.templateFactory = templateFactory;
        this.parser = parser;
        this.servletName = servletName;
    }

    public void transform(PortletBridgeMemento memento, PerPortletMemento perPortletMemento, URI currentUrl, RenderRequest request, RenderResponse response, Reader in) throws ResourceException {
        try {
            PortletPreferences preferences = request.getPreferences();
            String stylesheet = preferences.getValue("stylesheet", null);
            String stylesheetUrl = preferences.getValue("stylesheetUrl", null);
            Templates templates = null;
            templates = stylesheetUrl != null ? this.templateFactory.getTemplatesFromUrl(stylesheetUrl) : this.templateFactory.getTemplatesFromString(stylesheet);
            SerializerFactory factory = SerializerFactory.getSerializerFactory((String)"html");
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setPreserveSpace(true);
            outputFormat.setOmitDocumentType(true);
            outputFormat.setOmitXMLDeclaration(true);
            Serializer writer = factory.makeSerializer(outputFormat);
            PrintWriter responseWriter = response.getWriter();
            writer.setOutputCharStream((Writer)responseWriter);
            XslFilter filter = new XslFilter(templates);
            HashMap<String, BridgeFunctions> context = new HashMap<String, BridgeFunctions>();
            context.put("bridge", this.bridgeFunctionsFactory.createBridgeFunctions(memento, perPortletMemento, this.servletName, currentUrl, request, response));
            filter.setContext(context);
            filter.setParent(this.parser);
            filter.setContentHandler(writer.asContentHandler());
            InputSource inputSource = new InputSource(in);
            filter.parse(inputSource);
        }
        catch (TransformerConfigurationException e) {
            throw new ResourceException("error.transformer", (Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new ResourceException("error.filter.sax", (Object)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new ResourceException("error.filter.io", (Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void setTemplateFactory(TemplateFactory templateFactory) {
        this.templateFactory = templateFactory;
    }
}

