/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.util.filters;

import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.security.Encryption;
import org.apache.abdera.security.EncryptionOptions;
import org.apache.abdera.security.util.DHContext;
import org.apache.abdera.security.util.filters.AbstractEncryptedResponseFilter;

public class DHEncryptedResponseFilter
extends AbstractEncryptedResponseFilter {
    protected boolean doEncryption(RequestContext request, Object arg) {
        return arg != null;
    }

    protected Object initArg(RequestContext request) {
        return this.getDHContext(request);
    }

    protected EncryptionOptions initEncryptionOptions(RequestContext request, ResponseContext response, Encryption enc, Object arg) {
        EncryptionOptions options = null;
        try {
            DHContext context = (DHContext)arg;
            options = context.getEncryptionOptions(enc);
            this.returnPublicKey(response, context);
        }
        catch (Exception e) {
            // empty catch block
        }
        return options;
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        ResponseContext response = super.filter(request, chain);
        DHContext context = this.getDHContext(request);
        response.setHeader("Content-Encrypted", (Object)context.getResponseString());
        return response;
    }

    private void returnPublicKey(ResponseContext response, DHContext context) {
        response.setHeader("Content-Encrypted", (Object)context.getResponseString());
    }

    private DHContext getDHContext(RequestContext request) {
        try {
            String dh_req = request.getHeader("Accept-Encryption");
            if (dh_req == null || dh_req.length() == 0) {
                return null;
            }
            return new DHContext(dh_req);
        }
        catch (Exception e) {
            return null;
        }
    }
}

