/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.security.xmlsec;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.apache.abdera.Abdera;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Content;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Link;
import org.apache.abdera.model.Source;
import org.apache.abdera.security.SecurityException;
import org.apache.abdera.security.SecurityOptions;
import org.apache.abdera.security.SignatureOptions;
import org.apache.abdera.security.util.SignatureBase;
import org.apache.abdera.security.xmlsec.XmlSignatureOptions;
import org.apache.xml.security.Init;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.signature.XMLSignatureException;
import org.apache.xml.security.transforms.Transforms;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlSignature
extends SignatureBase {
    public XmlSignature() {
        super(new Abdera());
    }

    public XmlSignature(Abdera abdera) {
        super(abdera);
    }

    private <T extends Element> T _sign(T element, SignatureOptions options) throws XMLSecurityException {
        String[] refs;
        element.setBaseUri(element.getResolvedBaseUri());
        org.w3c.dom.Element dom = this.fomToDom((Element)element.clone(), (SecurityOptions)options);
        Document domdoc = dom.getOwnerDocument();
        PrivateKey signingKey = options.getSigningKey();
        X509Certificate cert = options.getCertificate();
        PublicKey pkey = options.getPublicKey();
        IRI baseUri = element.getResolvedBaseUri();
        XMLSignature sig = new XMLSignature(domdoc, baseUri != null ? baseUri.toString() : "", options.getSigningAlgorithm());
        dom.appendChild(sig.getElement());
        Transforms transforms = new Transforms(domdoc);
        transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
        transforms.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
        sig.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
        for (String ref : refs = options.getReferences()) {
            sig.addDocument(ref);
        }
        if (options.isSignLinks()) {
            String[] rels = options.getSignLinkRels();
            List<Link> links = null;
            Content content = null;
            if (element instanceof Source) {
                links = rels == null ? ((Source)element).getLinks() : ((Source)element).getLinks(rels);
            } else if (element instanceof Entry) {
                links = rels == null ? ((Entry)element).getLinks() : ((Entry)element).getLinks(rels);
                content = ((Entry)element).getContentElement();
            }
            if (links != null) {
                for (Link link : links) {
                    sig.addDocument(link.getResolvedHref().toASCIIString());
                }
            }
            if (content != null && content.getResolvedSrc() != null) {
                sig.addDocument(content.getResolvedSrc().toASCIIString());
            }
        }
        if (cert != null) {
            sig.addKeyInfo(cert);
        }
        if (pkey != null) {
            sig.addKeyInfo(pkey);
        }
        sig.sign((Key)signingKey);
        return (T)this.domToFom(dom, (SecurityOptions)options);
    }

    @Override
    public <T extends Element> T sign(T entry, SignatureOptions options) throws SecurityException {
        try {
            return this._sign(entry, options);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    private boolean is_valid_signature(XMLSignature sig, SignatureOptions options) throws XMLSignatureException, XMLSecurityException {
        KeyInfo ki = sig.getKeyInfo();
        if (ki != null) {
            X509Certificate cert = ki.getX509Certificate();
            if (cert != null) {
                return sig.checkSignatureValue(cert);
            }
            PublicKey key = ki.getPublicKey();
            if (key != null) {
                return sig.checkSignatureValue((Key)key);
            }
        } else if (options != null) {
            PublicKey key = options.getPublicKey();
            X509Certificate cert = options.getCertificate();
            if (key != null) {
                return sig.checkSignatureValue((Key)key);
            }
            if (cert != null) {
                return sig.checkSignatureValue(cert);
            }
        }
        return false;
    }

    private <T extends Element> X509Certificate[] _getcerts(T element, SignatureOptions options) throws XMLSignatureException, XMLSecurityException {
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        org.w3c.dom.Element dom = this.fomToDom(element, (SecurityOptions)options);
        NodeList children = dom.getChildNodes();
        for (int n = 0; n < children.getLength(); ++n) {
            try {
                X509Certificate cert;
                KeyInfo ki;
                IRI baseUri;
                XMLSignature sig;
                org.w3c.dom.Element el;
                Node node = children.item(n);
                if (node.getNodeType() != 1 || !"http://www.w3.org/2000/09/xmldsig#".equals((el = (org.w3c.dom.Element)node).getNamespaceURI()) || !"Signature".equals(el.getLocalName()) || !this.is_valid_signature(sig = new XMLSignature(el, (baseUri = element.getResolvedBaseUri()) != null ? baseUri.toString() : ""), options) || (ki = sig.getKeyInfo()) == null || (cert = ki.getX509Certificate()) == null) continue;
                certs.add(cert);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return certs.toArray(new X509Certificate[certs.size()]);
    }

    @Override
    public <T extends Element> X509Certificate[] getValidSignatureCertificates(T element, SignatureOptions options) throws SecurityException {
        try {
            return this._getcerts(element, options);
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public <T extends Element> KeyInfo getSignatureKeyInfo(T element, SignatureOptions options) throws SecurityException {
        KeyInfo ki = null;
        org.w3c.dom.Element dom = this.fomToDom(element, (SecurityOptions)options);
        NodeList children = dom.getChildNodes();
        for (int n = 0; n < children.getLength(); ++n) {
            try {
                org.w3c.dom.Element el;
                Node node = children.item(n);
                if (node.getNodeType() != 1 || !"http://www.w3.org/2000/09/xmldsig#".equals((el = (org.w3c.dom.Element)node).getNamespaceURI()) || !"Signature".equals(el.getLocalName())) continue;
                IRI baseUri = element.getResolvedBaseUri();
                XMLSignature sig = new XMLSignature(el, baseUri != null ? baseUri.toString() : "");
                ki = sig.getKeyInfo();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return ki;
    }

    private boolean _verify(Element element, SignatureOptions options) throws XMLSignatureException, XMLSecurityException {
        boolean answer = false;
        org.w3c.dom.Element dom = this.fomToDom(element, (SecurityOptions)options);
        NodeList children = dom.getChildNodes();
        for (int n = 0; n < children.getLength(); ++n) {
            org.w3c.dom.Element el;
            Node node = children.item(n);
            if (node.getNodeType() != 1 || !"http://www.w3.org/2000/09/xmldsig#".equals((el = (org.w3c.dom.Element)node).getNamespaceURI()) || !"Signature".equals(el.getLocalName())) continue;
            IRI baseUri = element.getResolvedBaseUri();
            XMLSignature sig = new XMLSignature(el, baseUri != null ? baseUri.toString() : "");
            answer = this.is_valid_signature(sig, options);
        }
        return answer;
    }

    @Override
    public <T extends Element> boolean verify(T entry, SignatureOptions options) throws SecurityException {
        if (!this.isSigned(entry)) {
            return false;
        }
        try {
            return this._verify(entry, options);
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    @Override
    public SignatureOptions getDefaultSignatureOptions() throws SecurityException {
        return new XmlSignatureOptions(this.getAbdera());
    }

    @Override
    public <T extends Element> T removeInvalidSignatures(T element, SignatureOptions options) throws SecurityException {
        ArrayList<org.w3c.dom.Element> remove = new ArrayList<org.w3c.dom.Element>();
        org.w3c.dom.Element dom = this.fomToDom(element, (SecurityOptions)options);
        NodeList children = dom.getChildNodes();
        for (int n = 0; n < children.getLength(); ++n) {
            try {
                IRI baseUri;
                XMLSignature sig;
                org.w3c.dom.Element el;
                Node node = children.item(n);
                if (node.getNodeType() != 1 || !"http://www.w3.org/2000/09/xmldsig#".equals((el = (org.w3c.dom.Element)node).getNamespaceURI()) || !"Signature".equals(el.getLocalName()) || this.is_valid_signature(sig = new XMLSignature(el, (baseUri = element.getResolvedBaseUri()) != null ? baseUri.toString() : ""), options)) continue;
                remove.add(el);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        for (org.w3c.dom.Element el : remove) {
            dom.removeChild(el);
        }
        return (T)this.domToFom(dom, (SecurityOptions)options);
    }

    static {
        if (!Init.isInitialized()) {
            Init.init();
        }
    }
}

