/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.resiliency.spi.agent;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.resiliency.spi.agent.SPIAgent;
import com.liferay.portal.util.PortalUtil;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AcceptorServlet
extends HttpServlet {
    private static Log _log = LogFactoryUtil.getLog(AcceptorServlet.class);

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PortalUtil.setPortalPort(request);
        ServletContext servletContext = this.getServletContext();
        String uriPath = PortalUtil.getPathContext();
        if (uriPath.isEmpty()) {
            uriPath = "/";
        }
        ServletContext portalServletContext = servletContext.getContext(uriPath);
        RequestDispatcher requestDispatcher = portalServletContext.getRequestDispatcher("/c/portal/resiliency");
        SPI spi = SPIUtil.getSPI();
        SPIAgent spiAgent = spi.getSPIAgent();
        HttpServletRequest spiAgentHttpServletRequest = spiAgent.prepareRequest(request);
        HttpServletResponse spiAgentHttpServletResponse = spiAgent.prepareResponse(request, response);
        Exception exception = null;
        try {
            requestDispatcher.forward((ServletRequest)spiAgentHttpServletRequest, (ServletResponse)spiAgentHttpServletResponse);
        }
        catch (Exception e) {
            exception = e;
        }
        spiAgent.transferResponse(spiAgentHttpServletRequest, spiAgentHttpServletResponse, exception);
        HttpSession session = spiAgentHttpServletRequest.getSession();
        session.invalidate();
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.doService(request, response);
        }
        catch (IOException ioe) {
            _log.error(ioe, ioe);
            throw ioe;
        }
        catch (RuntimeException re) {
            _log.error(re, re);
            throw re;
        }
    }
}

