/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.permission.PortalRuntimePermission;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class LocaleUtil {
    public static final Locale BRAZIL = new Locale("pt", "BR");
    public static final Locale CANADA = Locale.CANADA;
    public static final Locale CANADA_FRENCH = Locale.CANADA_FRENCH;
    public static final Locale CHINA = Locale.CHINA;
    public static final Locale CHINESE = Locale.CHINESE;
    public static final Locale ENGLISH = Locale.ENGLISH;
    public static final Locale FRANCE = Locale.FRANCE;
    public static final Locale FRENCH = Locale.FRENCH;
    public static final Locale GERMAN = Locale.GERMAN;
    public static final Locale GERMANY = Locale.GERMANY;
    public static final Locale HUNGARY = new Locale("hu", "HU");
    public static final Locale ITALIAN = Locale.ITALIAN;
    public static final Locale ITALY = Locale.ITALY;
    public static final Locale JAPAN = Locale.JAPAN;
    public static final Locale JAPANESE = Locale.JAPANESE;
    public static final Locale KOREA = Locale.KOREA;
    public static final Locale KOREAN = Locale.KOREAN;
    public static final Locale NETHERLANDS = new Locale("nl", "NL");
    public static final Locale PORTUGAL = new Locale("pt", "PT");
    public static final Locale PRC = Locale.PRC;
    public static final Locale ROOT = Locale.ROOT;
    public static final Locale SIMPLIFIED_CHINESE = Locale.SIMPLIFIED_CHINESE;
    public static final Locale SPAIN = new Locale("es", "ES");
    public static final Locale TAIWAN = Locale.TAIWAN;
    public static final Locale TRADITIONAL_CHINESE = Locale.TRADITIONAL_CHINESE;
    public static final Locale UK = Locale.UK;
    public static final Locale US = Locale.US;
    private static final String _BETA_SUFFIX = " [Beta]";
    private static Log _log = LogFactoryUtil.getLog(LocaleUtil.class);
    private static LocaleUtil _instance = new LocaleUtil();
    private Locale _locale;
    private Map<String, Locale> _locales = new HashMap<String, Locale>();

    public static boolean equals(Locale locale1, Locale locale2) {
        return LocaleUtil.getInstance()._equals(locale1, locale2);
    }

    public static Locale fromLanguageId(String languageId) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, true);
    }

    public static Locale fromLanguageId(String languageId, boolean validate) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, validate);
    }

    public static Locale fromLanguageId(String languageId, boolean validate, boolean useDefault) {
        return LocaleUtil.getInstance()._fromLanguageId(languageId, validate, useDefault);
    }

    public static Locale[] fromLanguageIds(List<String> languageIds) {
        return LocaleUtil.getInstance()._fromLanguageIds(languageIds);
    }

    public static Locale[] fromLanguageIds(String[] languageIds) {
        return LocaleUtil.getInstance()._fromLanguageIds(languageIds);
    }

    public static Locale getDefault() {
        return LocaleUtil.getInstance()._getDefault();
    }

    public static LocaleUtil getInstance() {
        PortalRuntimePermission.checkGetBeanProperty(LocaleUtil.class);
        return _instance;
    }

    public static Map<String, String> getISOLanguages(Locale locale) {
        return LocaleUtil.getInstance()._getISOLanguages(locale);
    }

    public static String getLongDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return LocaleUtil.getInstance()._getLongDisplayName(locale, duplicateLanguages);
    }

    public static Locale getMostRelevantLocale() {
        return LocaleUtil.getInstance()._getMostRelevantLocale();
    }

    public static String getShortDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return LocaleUtil.getInstance()._getShortDisplayName(locale, duplicateLanguages);
    }

    public static Locale getSiteDefault() {
        return LocaleUtil.getInstance()._getSiteDefault();
    }

    public static void setDefault(String userLanguage, String userCountry, String userVariant) {
        LocaleUtil.getInstance()._setDefault(userLanguage, userCountry, userVariant);
    }

    public static String toBCP47LanguageId(Locale locale) {
        return LocaleUtil.getInstance()._toBCP47LanguageId(locale);
    }

    public static String toBCP47LanguageId(String languageId) {
        return LocaleUtil.getInstance()._toBCP47LanguageId(languageId);
    }

    public static String[] toBCP47LanguageIds(Locale[] locales) {
        return LocaleUtil.getInstance()._toBCP47LanguageIds(locales);
    }

    public static String[] toBCP47LanguageIds(String[] languageIds) {
        return LocaleUtil.getInstance()._toBCP47LanguageIds(languageIds);
    }

    public static String[] toDisplayNames(Locale[] locales, Locale locale) {
        return LocaleUtil.getInstance()._toDisplayNames(locales, locale);
    }

    public static String toLanguageId(Locale locale) {
        return LocaleUtil.getInstance()._toLanguageId(locale);
    }

    public static String[] toLanguageIds(Locale[] locales) {
        return LocaleUtil.getInstance()._toLanguageIds(locales);
    }

    public static String toW3cLanguageId(Locale locale) {
        return LocaleUtil.getInstance()._toW3cLanguageId(locale);
    }

    public static String toW3cLanguageId(String languageId) {
        return LocaleUtil.getInstance()._toW3cLanguageId(languageId);
    }

    public static String[] toW3cLanguageIds(Locale[] locales) {
        return LocaleUtil.getInstance()._toW3cLanguageIds(locales);
    }

    public static String[] toW3cLanguageIds(String[] languageIds) {
        return LocaleUtil.getInstance()._toW3cLanguageIds(languageIds);
    }

    private LocaleUtil() {
        this._locale = new Locale("en", "US");
    }

    private boolean _equals(Locale locale1, Locale locale2) {
        String languageId1 = this._toLanguageId(locale1);
        String languageId2 = this._toLanguageId(locale2);
        return StringUtil.equalsIgnoreCase(languageId1, languageId2);
    }

    private Locale _fromLanguageId(String languageId, boolean validate) {
        return this._fromLanguageId(languageId, validate, true);
    }

    private Locale _fromLanguageId(String languageId, boolean validate, boolean useDefault) {
        Locale locale;
        block10: {
            if (languageId == null) {
                if (useDefault) {
                    return this._locale;
                }
                return null;
            }
            locale = this._locales.get(languageId);
            if (locale != null) {
                return locale;
            }
            try {
                int pos = languageId.indexOf(95);
                if (pos == -1) {
                    locale = new Locale(languageId);
                } else {
                    String[] languageIdParts = StringUtil.split(languageId, '_');
                    String languageCode = languageIdParts[0];
                    String countryCode = languageIdParts[1];
                    String variant = null;
                    if (languageIdParts.length > 2) {
                        variant = languageIdParts[2];
                    }
                    locale = Validator.isNotNull(variant) ? new Locale(languageCode, countryCode, variant) : new Locale(languageCode, countryCode);
                }
                if (validate && !LanguageUtil.isAvailableLanguageCode(languageId)) {
                    throw new IllegalArgumentException("Invalid locale " + locale);
                }
                this._locales.put(languageId, locale);
            }
            catch (Exception exception) {
                locale = null;
                if (!_log.isWarnEnabled()) break block10;
                _log.warn(String.valueOf(languageId) + " is not a valid language id");
            }
        }
        if (locale == null && useDefault) {
            locale = this._locale;
        }
        return locale;
    }

    private Locale[] _fromLanguageIds(List<String> languageIds) {
        Locale[] locales = new Locale[languageIds.size()];
        int i = 0;
        while (i < languageIds.size()) {
            locales[i] = this._fromLanguageId(languageIds.get(i), true);
            ++i;
        }
        return locales;
    }

    private Locale[] _fromLanguageIds(String[] languageIds) {
        Locale[] locales = new Locale[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            locales[i] = this._fromLanguageId(languageIds[i], true);
            ++i;
        }
        return locales;
    }

    private Locale _getDefault() {
        Locale locale = LocaleThreadLocal.getDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return this._locale;
    }

    private String _getDisplayName(String language, String country, Locale locale, Set<String> duplicateLanguages) {
        StringBundler sb = new StringBundler(6);
        sb.append(language);
        if (duplicateLanguages.contains(locale.getLanguage())) {
            sb.append(" ");
            sb.append("(");
            sb.append(country);
            sb.append(")");
        }
        if (LanguageUtil.isBetaLocale(locale)) {
            sb.append(_BETA_SUFFIX);
        }
        return sb.toString();
    }

    private Map<String, String> _getISOLanguages(Locale locale) {
        TreeMap<String, String> isoLanguages = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        String[] stringArray = Locale.getISOLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String isoLanguageId = stringArray[n2];
            Locale isoLocale = this._fromLanguageId(isoLanguageId, true);
            isoLanguages.put(isoLocale.getDisplayLanguage(locale), isoLanguageId);
            ++n2;
        }
        return isoLanguages;
    }

    private String _getLongDisplayName(Locale locale, Set<String> duplicateLanguages) {
        return this._getDisplayName(locale.getDisplayLanguage(locale), locale.getDisplayCountry(locale), locale, duplicateLanguages);
    }

    private Locale _getMostRelevantLocale() {
        Locale locale = LocaleThreadLocal.getThemeDisplayLocale();
        if (locale == null) {
            locale = this._getDefault();
        }
        return locale;
    }

    private String _getShortDisplayName(Locale locale, Set<String> duplicateLanguages) {
        String language = locale.getDisplayLanguage(locale);
        if (language.length() > 3) {
            language = locale.getLanguage();
            language = StringUtil.toUpperCase(language);
        }
        String country = locale.getCountry();
        return this._getDisplayName(language, StringUtil.toUpperCase(country), locale, duplicateLanguages);
    }

    private Locale _getSiteDefault() {
        Locale locale = LocaleThreadLocal.getSiteDefaultLocale();
        if (locale != null) {
            return locale;
        }
        return this._getDefault();
    }

    private void _setDefault(String userLanguage, String userCountry, String userVariant) {
        PortalRuntimePermission.checkSetBeanProperty(this.getClass());
        if (Validator.isNotNull(userLanguage) && Validator.isNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry);
        } else if (Validator.isNotNull(userLanguage) && Validator.isNotNull(userCountry) && Validator.isNotNull(userVariant)) {
            this._locale = new Locale(userLanguage, userCountry, userVariant);
        }
    }

    private String _toBCP47LanguageId(Locale locale) {
        return this._toBCP47LanguageId(this._toLanguageId(locale));
    }

    private String _toBCP47LanguageId(String languageId) {
        if (languageId.equals("zh_CN")) {
            return "zh-Hans-CN";
        }
        if (languageId.equals("zh_TW")) {
            return "zh-Hant-TW";
        }
        return StringUtil.replace(languageId, '_', '-');
    }

    private String[] _toBCP47LanguageIds(Locale[] locales) {
        return this._toBCP47LanguageIds(this._toLanguageIds(locales));
    }

    private String[] _toBCP47LanguageIds(String[] languageIds) {
        String[] bcp47LanguageIds = new String[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            bcp47LanguageIds[i] = this._toBCP47LanguageId(languageIds[i]);
            ++i;
        }
        return bcp47LanguageIds;
    }

    private String[] _toDisplayNames(Locale[] locales, Locale locale) {
        String[] displayNames = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            displayNames[i] = locales[i].getDisplayName(locale);
            ++i;
        }
        return displayNames;
    }

    private String _toLanguageId(Locale locale) {
        if (locale == null) {
            locale = this._locale;
        }
        String country = locale.getCountry();
        boolean hasCountry = false;
        if (country.length() != 0) {
            hasCountry = true;
        }
        String variant = locale.getVariant();
        boolean hasVariant = false;
        if (variant.length() != 0) {
            hasVariant = true;
        }
        if (!hasCountry && !hasVariant) {
            return locale.getLanguage();
        }
        int length = 3;
        if (hasCountry && hasVariant) {
            length = 5;
        }
        StringBundler sb = new StringBundler(length);
        sb.append(locale.getLanguage());
        if (hasCountry) {
            sb.append("_");
            sb.append(country);
        }
        if (hasVariant) {
            sb.append("_");
            sb.append(variant);
        }
        return sb.toString();
    }

    private String[] _toLanguageIds(Locale[] locales) {
        String[] languageIds = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            languageIds[i] = this._toLanguageId(locales[i]);
            ++i;
        }
        return languageIds;
    }

    private String _toW3cLanguageId(Locale locale) {
        return this._toW3cLanguageId(this._toLanguageId(locale));
    }

    private String _toW3cLanguageId(String languageId) {
        return StringUtil.replace(languageId, '_', '-');
    }

    private String[] _toW3cLanguageIds(Locale[] locales) {
        return this._toW3cLanguageIds(this._toLanguageIds(locales));
    }

    private String[] _toW3cLanguageIds(String[] languageIds) {
        String[] w3cLanguageIds = new String[languageIds.length];
        int i = 0;
        while (i < languageIds.length) {
            w3cLanguageIds[i] = this._toW3cLanguageId(languageIds[i]);
            ++i;
        }
        return w3cLanguageIds;
    }
}

