/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.repository.proxy;

import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.UnmodifiableList;
import com.liferay.portal.repository.proxy.FileEntryProxyBean;
import com.liferay.portal.repository.proxy.FileVersionProxyBean;
import com.liferay.portal.repository.proxy.FolderProxyBean;
import com.liferay.portal.repository.proxy.LocalRepositoryProxyBean;
import java.util.ArrayList;
import java.util.List;

public abstract class RepositoryModelProxyBean {
    private ClassLoader _classLoader;

    public RepositoryModelProxyBean(ClassLoader classLoader) {
        this._classLoader = classLoader;
    }

    protected FileEntryProxyBean newFileEntryProxyBean(FileEntry fileEntry) {
        if (fileEntry == null) {
            return null;
        }
        FileEntry fileEntryProxy = (FileEntry)this.newProxyInstance(fileEntry, FileEntry.class);
        return new FileEntryProxyBean(fileEntryProxy, this._classLoader);
    }

    protected FileVersionProxyBean newFileVersionProxyBean(FileVersion fileVersion) {
        if (fileVersion == null) {
            return null;
        }
        FileVersion fileVersionProxy = (FileVersion)this.newProxyInstance(fileVersion, FileVersion.class);
        return new FileVersionProxyBean(fileVersionProxy, this._classLoader);
    }

    protected FolderProxyBean newFolderProxyBean(Folder folder) {
        if (folder == null) {
            return null;
        }
        Folder folderProxy = (Folder)this.newProxyInstance(folder, Folder.class);
        return new FolderProxyBean(folderProxy, this._classLoader);
    }

    protected LocalRepositoryProxyBean newLocalRepositoryProxyBean(LocalRepository localRepository) {
        LocalRepository localRepositoryProxy = (LocalRepository)this.newProxyInstance(localRepository, LocalRepository.class);
        return new LocalRepositoryProxyBean(localRepositoryProxy, this._classLoader);
    }

    protected Object newProxyBean(Object bean) {
        if (bean instanceof FileEntry) {
            return this.newFileEntryProxyBean((FileEntry)bean);
        }
        if (bean instanceof FileVersion) {
            return this.newFileVersionProxyBean((FileVersion)bean);
        }
        if (bean instanceof Folder) {
            return this.newFolderProxyBean((Folder)bean);
        }
        return bean;
    }

    protected Object newProxyInstance(Object bean, Class<?> clazz) {
        if (bean == null) {
            return null;
        }
        return ProxyUtil.newProxyInstance(this._classLoader, new Class[]{clazz}, new ClassLoaderBeanHandler(bean, this._classLoader));
    }

    protected List<FileEntry> toFileEntryProxyBeans(List<FileEntry> fileEntries) {
        if (fileEntries == null || fileEntries.isEmpty()) {
            return fileEntries;
        }
        ArrayList<FileEntry> fileEntryProxyBeans = new ArrayList<FileEntry>(fileEntries.size());
        for (FileEntry fileEntry : fileEntries) {
            fileEntryProxyBeans.add(this.newFileEntryProxyBean(fileEntry));
        }
        if (fileEntries instanceof UnmodifiableList) {
            return new UnmodifiableList<FileEntry>(fileEntries);
        }
        return fileEntryProxyBeans;
    }

    protected List<FileVersion> toFileVersionProxyBeans(List<FileVersion> fileVersions) {
        if (fileVersions == null || fileVersions.isEmpty()) {
            return fileVersions;
        }
        ArrayList<FileVersion> fileVersionProxyBeans = new ArrayList<FileVersion>(fileVersions.size());
        for (FileVersion fileVersion : fileVersions) {
            fileVersionProxyBeans.add(this.newFileVersionProxyBean(fileVersion));
        }
        if (fileVersions instanceof UnmodifiableList) {
            return new UnmodifiableList<FileVersion>(fileVersions);
        }
        return fileVersionProxyBeans;
    }

    protected List<Folder> toFolderProxyBeans(List<Folder> folders) {
        if (folders == null || folders.isEmpty()) {
            return folders;
        }
        ArrayList<Folder> folderProxyBeans = new ArrayList<Folder>(folders.size());
        for (Folder folder : folders) {
            folderProxyBeans.add(this.newFolderProxyBean(folder));
        }
        if (folders instanceof UnmodifiableList) {
            return new UnmodifiableList<Folder>(folderProxyBeans);
        }
        return folderProxyBeans;
    }

    protected List<Object> toObjectProxyBeans(List<Object> objects) {
        if (objects == null || objects.isEmpty()) {
            return objects;
        }
        ArrayList<Object> objectProxyBeans = new ArrayList<Object>();
        for (Object object : objects) {
            objectProxyBeans.add(this.newProxyBean(object));
        }
        if (objects instanceof UnmodifiableList) {
            return new UnmodifiableList<Object>(objectProxyBeans);
        }
        return objectProxyBeans;
    }
}

