/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.application.framework.core.cache.factories;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import org.gcube.application.framework.core.genericresources.model.ISGenericResource;
import org.gcube.application.framework.core.util.QueryString;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.common.resources.gcore.ScopeGroup;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericResourceCacheEntryFactory
implements CacheEntryFactory {
    static DiscoveryClient<GenericResource> client = null;
    private static final Logger logger = LoggerFactory.getLogger(GenericResourceCacheEntryFactory.class);

    public GenericResourceCacheEntryFactory() {
        if (client == null) {
            try {
                client = ICFactory.clientFor(GenericResource.class);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
        }
    }

    public List<ISGenericResource> createEntry(Object key) throws Exception {
        QueryString querySt = (QueryString)key;
        logger.info("query: " + querySt.toString());
        String scope = ScopeProvider.instance.get();
        XQuery query = ICFactory.queryFor(GenericResource.class);
        logger.info("In generic resources cache entry factory");
        if (querySt.containsKey("id")) {
            query.addCondition("$resource/ID eq '" + (String)querySt.get("id") + "'");
        } else if (querySt.containsKey("name")) {
            query.addCondition("$resource/Profile/Name eq '" + (String)querySt.get("name") + "'");
        } else if (querySt.containsKey("vreResource")) {
            String secondaryType = new String();
            ScopeBean sb = new ScopeBean(ScopeProvider.instance.get());
            secondaryType = sb.is(ScopeBean.Type.VRE) ? ScopeBean.Type.VRE.name() : (sb.is(ScopeBean.Type.VO) ? ScopeBean.Type.VO.name() : ScopeBean.Type.INFRASTRUCTURE.name());
            query.addCondition("$resource/Profile/SecondaryType eq '" + secondaryType + "'").addCondition("$resource/Scopes eq '" + scope + "'");
        }
        try {
            ArrayList<Object> results = client.submit((Query)query);
            if (querySt.containsKey("name") && ((String)querySt.get("name")).equals("ScenarioCollectionInfo")) {
                logger.info("The number of generic Resources for ScenarioSchemaInfo returned is: " + results.size());
                ArrayList<Object> newResult = new ArrayList<Object>();
                for (Object resource : results) {
                    ScopeGroup scopeGroup = resource.scopes();
                    logger.info("Number of scopes for ScenarioSchemaInfo: " + scopeGroup.size());
                    if (!scopeGroup.contains((Object)scope)) continue;
                    newResult.add(resource);
                }
                if (newResult.size() > 1) {
                    GenericResource voResource = null;
                    for (GenericResource genericResource : newResult) {
                        if (genericResource.scopes().size() != 1) continue;
                        voResource = genericResource;
                        break;
                    }
                    newResult.clear();
                    newResult.add(voResource);
                }
                logger.info("Number of genericResources for ScenarioSchemaInfo left after the pruning" + newResult.size());
                results = newResult;
            }
            logger.debug("size of results: " + results.size());
            ArrayList<ISGenericResource> res = new ArrayList<ISGenericResource>();
            for (Object resource : results) {
                ISGenericResource iSGenericResource = new ISGenericResource(resource.id(), resource.profile().name(), resource.profile().description(), resource.profile().bodyAsString(), resource.profile().type());
                res.add(iSGenericResource);
            }
            return res;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }
}

