/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.taglib.aui;

import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class AUIUtil {
    public static final String BUTTON_INPUT_PREFIX = "btn-input";
    public static final String BUTTON_PREFIX = "btn";
    public static final String FIELD_PREFIX = "field";
    public static final String INPUT_PREFIX = "field-input";
    public static final String LABEL_CHOICE_PREFIX = "choice-label";
    public static final String LABEL_FIELD_PREFIX = "field-label";

    public static String buildControlGroupCss(boolean inlineField, String inlineLabel, String wrapperCssClass, String baseType) {
        StringBundler sb = new StringBundler(9);
        sb.append("control-group");
        if (inlineField) {
            sb.append(" control-group-inline");
        }
        if (Validator.isNotNull((String)inlineLabel)) {
            sb.append(" form-inline");
        }
        if (Validator.isNotNull((String)wrapperCssClass)) {
            sb.append(" ");
            sb.append(wrapperCssClass);
        }
        if (Validator.isNotNull((String)baseType)) {
            sb.append(" ");
            sb.append("input-");
            sb.append(baseType);
            sb.append("-wrapper");
        }
        return sb.toString();
    }

    public static String buildCss(String prefix, boolean disabled, boolean first, boolean last, String cssClass) {
        StringBundler sb = new StringBundler();
        sb.append(prefix);
        if (disabled) {
            sb.append(" ");
            sb.append("disabled");
        }
        if (first) {
            sb.append(" ");
            sb.append(prefix);
            sb.append("-first");
        } else if (last) {
            sb.append(" ");
            sb.append(prefix);
            sb.append("-last");
        }
        if (Validator.isNotNull((String)cssClass)) {
            sb.append(" ");
            sb.append(cssClass);
        }
        return sb.toString();
    }

    public static String buildCss(String prefix, String baseTypeCss, boolean disabled, boolean first, boolean last, String cssClass) {
        return AUIUtil.buildCss(prefix, disabled, first, last, cssClass);
    }

    public static String buildData(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(data.size() * 5);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String dataKey = entry.getKey();
            String dataValue = String.valueOf(entry.getValue());
            sb.append("data-");
            sb.append(dataKey);
            sb.append("=\"");
            sb.append(HtmlUtil.escapeAttribute((String)dataValue));
            sb.append("\" ");
        }
        return sb.toString();
    }

    public static String buildLabel(String baseType, boolean inlineField, boolean showForLabel, String forLabel) {
        StringBundler sb = new StringBundler(7);
        if (baseType.equals("boolean")) {
            baseType = "checkbox";
        }
        if (baseType.equals("checkbox") || baseType.equals("radio")) {
            sb.append("class=\"");
            sb.append(baseType);
            if (inlineField) {
                sb.append(" inline");
            }
            sb.append("\" ");
        } else {
            sb.append("class=\"control-label\" ");
        }
        if (showForLabel) {
            sb.append("for=\"");
            sb.append(HtmlUtil.escapeAttribute((String)forLabel));
            sb.append("\"");
        }
        return sb.toString();
    }

    public static String buildLabel(String inlineLabel, boolean showForLabel, String forLabel, boolean choiceField) {
        return AUIUtil.buildLabel("", false, showForLabel, forLabel);
    }
}

