/*
 * Decompiled with CFR 0.152.
 */
package com.browseengine.bobo.search;

import com.browseengine.bobo.api.BoboIndexReader;
import com.browseengine.bobo.docidset.RandomAccessDocIdSet;
import com.browseengine.bobo.facets.FacetCountCollector;
import com.browseengine.bobo.facets.FacetCountCollectorSource;
import com.browseengine.bobo.mapred.BoboMapFunctionWrapper;
import com.browseengine.bobo.search.FacetHitCollector;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ReaderUtil;

public class BoboSearcher2
extends IndexSearcher {
    protected List<FacetHitCollector> _facetCollectors = new LinkedList<FacetHitCollector>();
    protected BoboIndexReader[] _subReaders;
    protected int[] _docStarts;

    public BoboSearcher2(BoboIndexReader reader) {
        super((IndexReader)reader);
        ArrayList readerList = new ArrayList();
        ReaderUtil.gatherSubReaders(readerList, (IndexReader)reader);
        this._subReaders = readerList.toArray(new BoboIndexReader[readerList.size()]);
        this._docStarts = new int[this._subReaders.length];
        int maxDoc = 0;
        for (int i = 0; i < this._subReaders.length; ++i) {
            this._docStarts[i] = maxDoc;
            maxDoc += this._subReaders[i].maxDoc();
        }
    }

    public void setFacetHitCollectorList(List<FacetHitCollector> facetHitCollectors) {
        if (facetHitCollectors != null) {
            this._facetCollectors = facetHitCollectors;
        }
    }

    protected FacetValidator createFacetValidator() throws IOException {
        FacetHitCollector[] collectors = new FacetHitCollector[this._facetCollectors.size()];
        FacetCountCollectorSource[] countCollectors = new FacetCountCollectorSource[collectors.length];
        int i = 0;
        int j = collectors.length;
        for (FacetHitCollector facetCollector : this._facetCollectors) {
            if (facetCollector._filter != null) {
                collectors[i] = facetCollector;
                countCollectors[i] = facetCollector._facetCountCollectorSource;
                ++i;
                continue;
            }
            collectors[--j] = facetCollector;
            countCollectors[j] = facetCollector._facetCountCollectorSource;
        }
        int numPostFilters = i;
        if (numPostFilters == 0) {
            return new NoNeedFacetValidator(collectors);
        }
        if (numPostFilters == 1) {
            return new OnePostFilterFacetValidator(collectors);
        }
        return new DefaultFacetValidator(collectors, numPostFilters);
    }

    public void search(Weight weight, Filter filter, Collector collector) throws IOException {
        this.search(weight, filter, collector, 0, null);
    }

    public void search(Weight weight, Filter filter, Collector collector, int start, BoboMapFunctionWrapper mapReduceWrapper) throws IOException {
        FacetValidator validator = this.createFacetValidator();
        int target = 0;
        if (filter == null) {
            for (int i = 0; i < this._subReaders.length; ++i) {
                int docStart = start + this._docStarts[i];
                collector.setNextReader((IndexReader)this._subReaders[i], docStart);
                validator.setNextReader(this._subReaders[i], docStart);
                Scorer scorer = weight.scorer((IndexReader)this._subReaders[i], true, true);
                if (scorer != null) {
                    collector.setScorer(scorer);
                    target = scorer.nextDoc();
                    while (target != Integer.MAX_VALUE) {
                        if (validator.validate(target)) {
                            collector.collect(target);
                            target = scorer.nextDoc();
                            continue;
                        }
                        target = validator._nextTarget;
                        target = scorer.advance(target);
                    }
                }
                if (mapReduceWrapper == null) continue;
                mapReduceWrapper.mapFullIndexReader(this._subReaders[i], validator.getCountCollectors());
            }
            return;
        }
        block2: for (int i = 0; i < this._subReaders.length; ++i) {
            DocIdSet filterDocIdSet = filter.getDocIdSet((IndexReader)this._subReaders[i]);
            if (filterDocIdSet == null) {
                return;
            }
            int docStart = start + this._docStarts[i];
            collector.setNextReader((IndexReader)this._subReaders[i], docStart);
            validator.setNextReader(this._subReaders[i], docStart);
            Scorer scorer = weight.scorer((IndexReader)this._subReaders[i], true, false);
            if (scorer == null) continue;
            collector.setScorer(scorer);
            DocIdSetIterator filterDocIdIterator = filterDocIdSet.iterator();
            if (filterDocIdIterator == null) continue;
            int doc = -1;
            target = filterDocIdIterator.nextDoc();
            if (mapReduceWrapper == null) {
                while (target < Integer.MAX_VALUE) {
                    if (doc < target) {
                        doc = scorer.advance(target);
                    }
                    if (doc == target) {
                        if (validator.validate(doc)) {
                            collector.collect(doc);
                            target = filterDocIdIterator.nextDoc();
                            continue;
                        }
                        target = filterDocIdIterator.advance(validator._nextTarget);
                        continue;
                    }
                    if (doc == Integer.MAX_VALUE) continue block2;
                    target = filterDocIdIterator.advance(doc);
                }
                continue;
            }
            while (target < Integer.MAX_VALUE) {
                if (doc < target) {
                    doc = scorer.advance(target);
                }
                if (doc == target) {
                    if (validator.validate(doc)) {
                        mapReduceWrapper.mapSingleDocument(doc, this._subReaders[i]);
                        collector.collect(doc);
                        target = filterDocIdIterator.nextDoc();
                        continue;
                    }
                    target = filterDocIdIterator.advance(validator._nextTarget);
                    continue;
                }
                if (doc == Integer.MAX_VALUE) break;
                target = filterDocIdIterator.advance(doc);
            }
            mapReduceWrapper.finalizeSegment(this._subReaders[i], validator.getCountCollectors());
        }
    }

    private static final class NoNeedFacetValidator
    extends FacetValidator {
        NoNeedFacetValidator(FacetHitCollector[] collectors) throws IOException {
            super(collectors, 0);
        }

        @Override
        public final boolean validate(int docid) throws IOException {
            for (FacetCountCollector collector : this._countCollectors) {
                collector.collect(docid);
            }
            return true;
        }
    }

    private static final class OnePostFilterFacetValidator
    extends FacetValidator {
        private FacetHitCollector _firsttime;

        OnePostFilterFacetValidator(FacetHitCollector[] collectors) throws IOException {
            super(collectors, 1);
            this._firsttime = this._collectors[0];
        }

        @Override
        public final boolean validate(int docid) throws IOException {
            FacetHitCollector.CurrentPointers miss = null;
            RandomAccessDocIdSet set = this._firsttime._currentPointers.docidSet;
            if (set != null && !set.get(docid)) {
                miss = this._firsttime._currentPointers;
            }
            this._nextTarget = docid + 1;
            if (miss != null) {
                miss.facetCountCollector.collect(docid);
                return false;
            }
            for (FacetCountCollector collector : this._countCollectors) {
                collector.collect(docid);
            }
            return true;
        }
    }

    private static final class DefaultFacetValidator
    extends FacetValidator {
        public DefaultFacetValidator(FacetHitCollector[] collectors, int numPostFilters) throws IOException {
            super(collectors, numPostFilters);
        }

        @Override
        public final boolean validate(int docid) throws IOException {
            FacetHitCollector.CurrentPointers miss = null;
            for (int i = 0; i < this._numPostFilters; ++i) {
                FacetHitCollector.CurrentPointers cur = this._collectors[i]._currentPointers;
                int sid = cur.doc;
                if (sid < docid) {
                    cur.doc = sid = cur.postDocIDSetIterator.advance(docid);
                    if (sid == Integer.MAX_VALUE) {
                        FacetHitCollector tmp = this._collectors[0];
                        this._collectors[0] = this._collectors[i];
                        this._collectors[i] = tmp;
                    }
                }
                if (sid <= docid) continue;
                if (miss != null) {
                    this._nextTarget = miss.doc < cur.doc ? miss.doc : cur.doc;
                    return false;
                }
                miss = cur;
            }
            this._nextTarget = docid + 1;
            if (miss != null) {
                miss.facetCountCollector.collect(docid);
                return false;
            }
            for (FacetCountCollector collector : this._countCollectors) {
                collector.collect(docid);
            }
            return true;
        }
    }

    static abstract class FacetValidator {
        protected final FacetHitCollector[] _collectors;
        protected final int _numPostFilters;
        protected FacetCountCollector[] _countCollectors;
        public int _nextTarget;

        private void sortPostCollectors(final BoboIndexReader reader) {
            Comparator<FacetHitCollector> comparator = new Comparator<FacetHitCollector>(){

                @Override
                public int compare(FacetHitCollector fhc1, FacetHitCollector fhc2) {
                    double selectivity2;
                    double selectivity1 = fhc1._filter.getFacetSelectivity(reader);
                    if (selectivity1 < (selectivity2 = fhc2._filter.getFacetSelectivity(reader))) {
                        return -1;
                    }
                    if (selectivity1 > selectivity2) {
                        return 1;
                    }
                    return 0;
                }
            };
            Arrays.sort(this._collectors, 0, this._numPostFilters, comparator);
        }

        public FacetValidator(FacetHitCollector[] collectors, int numPostFilters) throws IOException {
            this._collectors = collectors;
            this._numPostFilters = numPostFilters;
            this._countCollectors = new FacetCountCollector[collectors.length];
        }

        public abstract boolean validate(int var1) throws IOException;

        public void setNextReader(BoboIndexReader reader, int docBase) throws IOException {
            ArrayList<FacetCountCollector> collectorList = new ArrayList<FacetCountCollector>();
            this.sortPostCollectors(reader);
            for (int i = 0; i < this._collectors.length; ++i) {
                this._collectors[i].setNextReader(reader, docBase);
                FacetCountCollector collector = this._collectors[i]._currentPointers.facetCountCollector;
                if (collector == null) continue;
                collectorList.add(collector);
            }
            this._countCollectors = collectorList.toArray(new FacetCountCollector[collectorList.size()]);
        }

        public FacetCountCollector[] getCountCollectors() {
            ArrayList<FacetCountCollector> collectors = new ArrayList<FacetCountCollector>();
            collectors.addAll(Arrays.asList(this._countCollectors));
            for (FacetHitCollector facetHitCollector : this._collectors) {
                collectors.addAll(facetHitCollector._collectAllCollectorList);
                collectors.addAll(facetHitCollector._countCollectorList);
            }
            return collectors.toArray(new FacetCountCollector[collectors.size()]);
        }
    }
}

