/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.text;

import com.liferay.ibm.icu.impl.NormalizerImpl;

public final class ComposedCharIter {
    public static final char DONE = '\uffff';
    private boolean compat;
    private char[] decompBuf = new char[100];
    private int bufLen = 0;
    private int curChar = 0;
    private int nextChar = -1;

    public ComposedCharIter() {
        this.compat = false;
    }

    public ComposedCharIter(boolean compat, int options) {
        this.compat = compat;
    }

    public boolean hasNext() {
        if (this.nextChar == -1) {
            this.findNextChar();
        }
        return this.nextChar != -1;
    }

    public char next() {
        if (this.nextChar == -1) {
            this.findNextChar();
        }
        this.curChar = this.nextChar;
        this.nextChar = -1;
        return (char)this.curChar;
    }

    public String decomposition() {
        return new String(this.decompBuf, 0, this.bufLen);
    }

    private void findNextChar() {
        int c;
        block2: {
            for (c = this.curChar + 1; c < 65535; ++c) {
                this.bufLen = NormalizerImpl.getDecomposition(c, this.compat, this.decompBuf, 0, this.decompBuf.length);
                if (this.bufLen <= 0) {
                    continue;
                }
                break block2;
            }
            c = -1;
        }
        this.nextChar = c;
    }
}

