/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.doubles;

import it.unimi.dsi.fastutil.doubles.AbstractDoubleComparator;
import it.unimi.dsi.fastutil.doubles.DoubleComparator;

public class DoubleComparators {
    public static final DoubleComparator NATURAL_COMPARATOR = new AbstractDoubleComparator(){

        public final int compare(double a, double b) {
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    };
    public static final DoubleComparator OPPOSITE_COMPARATOR = new AbstractDoubleComparator(){

        public final int compare(double a, double b) {
            return b < a ? -1 : (b == a ? 0 : 1);
        }
    };

    private DoubleComparators() {
    }

    public static DoubleComparator oppositeComparator(final DoubleComparator c) {
        return new AbstractDoubleComparator(){
            private final DoubleComparator comparator;
            {
                this.comparator = c;
            }

            public final int compare(double a, double b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

