/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.cluster;

import org.apache.jackrabbit.core.cluster.ChangeLogRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecord;
import org.apache.jackrabbit.core.cluster.ClusterRecordProcessor;
import org.apache.jackrabbit.core.cluster.LockRecord;
import org.apache.jackrabbit.core.cluster.NamespaceRecord;
import org.apache.jackrabbit.core.cluster.NodeTypeRecord;
import org.apache.jackrabbit.core.cluster.WorkspaceRecord;
import org.apache.jackrabbit.core.journal.JournalException;
import org.apache.jackrabbit.core.journal.Record;

public class ClusterRecordDeserializer {
    public ClusterRecord deserialize(Record record) throws JournalException {
        ClusterRecord clusterRecord;
        String workspace = record.readString();
        char c = record.readChar();
        switch (c) {
            case 'D': 
            case 'E': 
            case 'N': 
            case 'P': {
                clusterRecord = new ChangeLogRecord(c, record, workspace);
                clusterRecord.read();
                break;
            }
            case 'L': {
                clusterRecord = new LockRecord(record, workspace);
                clusterRecord.read();
                break;
            }
            case 'S': {
                clusterRecord = new NamespaceRecord(record);
                clusterRecord.read();
                break;
            }
            case 'T': {
                clusterRecord = new NodeTypeRecord(record);
                clusterRecord.read();
                break;
            }
            case 'W': {
                clusterRecord = new WorkspaceRecord(record);
                clusterRecord.read();
                break;
            }
            case '\u0000': {
                clusterRecord = new ClusterRecord(record){

                    protected void doRead() {
                    }

                    protected void doWrite() {
                    }

                    public void process(ClusterRecordProcessor processor) {
                    }
                };
                break;
            }
            default: {
                throw new JournalException("Unknown record identifier: " + c);
            }
        }
        return clusterRecord;
    }
}

