/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.concurrent.locks.Lock;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.RowActionBase;
import org.hsqldb.Session;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlDeque;
import org.hsqldb.lib.IntKeyHashMapConcurrent;
import org.hsqldb.lib.LongDeque;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManagerMVCC
extends TransactionManagerCommon
implements TransactionManager {
    HsqlDeque committedTransactions = new HsqlDeque();
    LongDeque committedTransactionTimestamps = new LongDeque();
    boolean isLockedMode;
    Session catalogWriteSession;
    long lockTxTs;
    long lockSessionId;
    long unlockTxTs;
    long unlockSessionId;
    int redoCount = 0;

    public TransactionManagerMVCC(Database db) {
        this.database = db;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.rowActionMap = new IntKeyHashMapConcurrent(10000);
        this.txModel = 2;
    }

    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public boolean isMVRows() {
        return true;
    }

    public boolean isMVCC() {
        return true;
    }

    public int getTransactionControl() {
        return 2;
    }

    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    public void completeActions(Session session) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean prepareCommitActions(Session session) {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                Object[] list = session.rowActionList.getArray();
                int limit = session.rowActionList.size();
                if (session.abortTransaction) {
                    return false;
                }
                this.writeLock.lock();
                try {
                    int i;
                    for (i = 0; i < limit; ++i) {
                        RowAction rowact = (RowAction)list[i];
                        if (rowact.canCommit(session, session.tempSet)) continue;
                        bl2 = false;
                        Object var8_7 = null;
                        this.writeLock.unlock();
                        break block6;
                    }
                    session.actionTimestamp = this.nextChangeTimestamp();
                    for (i = 0; i < limit; ++i) {
                        RowAction action = (RowAction)list[i];
                        action.prepareCommit(session);
                    }
                    for (i = 0; i < session.tempSet.size(); ++i) {
                        Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                        current.abortTransaction = true;
                    }
                    bl = true;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    this.writeLock.unlock();
                    session.tempSet.clear();
                    throw throwable;
                }
            }
            session.tempSet.clear();
            return bl2;
        }
        Object var8_8 = null;
        this.writeLock.unlock();
        session.tempSet.clear();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int limit = session.rowActionList.size();
        Object[] list = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            int i;
            for (i = 0; i < limit; ++i) {
                RowAction rowact = (RowAction)list[i];
                if (rowact.canCommit(session, session.tempSet)) continue;
                boolean bl = false;
                Object var8_7 = null;
                this.writeLock.unlock();
                return bl;
            }
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.commit(session);
            }
            for (i = 0; i < session.tempSet.size(); ++i) {
                Session current = ((RowActionBase)session.tempSet.get((int)i)).session;
                current.abortTransaction = true;
            }
            this.persistCommit(session, list, limit);
            int newLimit = session.rowActionList.size();
            if (newLimit > limit) {
                list = session.rowActionList.getArray();
                this.mergeTransaction(session, list, limit, newLimit, session.actionTimestamp);
                this.finaliseRows(session, list, limit, newLimit, true);
                session.rowActionList.setSize(limit);
            }
            if (this.getFirstLiveTransactionTimestamp() > session.actionTimestamp || session == this.lobSession) {
                this.mergeTransaction(session, list, 0, limit, session.actionTimestamp);
                this.finaliseRows(session, list, 0, limit, true);
            } else if (session.rowActionList.size() > 0) {
                list = session.rowActionList.toArray();
                this.addToCommittedQueue(session, list);
            }
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var8_8 = null;
        this.writeLock.unlock();
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Session session) {
        this.writeLock.lock();
        try {
            session.abortTransaction = false;
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.rollbackPartial(session, 0, session.transactionTimestamp);
            this.endTransaction(session);
            this.endTransactionTPL(session);
            session.isTransaction = false;
            this.countDownLatches(session);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = start; i < limit; ++i) {
            RowAction action = (RowAction)list[i];
            if (action != null) {
                action.rollback(session, timestamp);
                continue;
            }
            System.out.println("null action in rollback " + start);
        }
        this.writeLock.lock();
        try {
            this.mergeRolledBackTransaction(session, timestamp, list, start, limit);
            this.finaliseRows(session, list, start, limit, false);
            Object var10_8 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        session.rowActionList.setSize(start);
    }

    public RowAction addDeleteAction(Session session, Table table, Row row, int[] colMap) {
        RowAction action = this.addDeleteActionToRow(session, table, row, colMap);
        Session actionSession = null;
        boolean redoAction = true;
        if (action == null) {
            this.writeLock.lock();
            try {
                this.rollbackAction(session);
                if (session.isolationLevel == 4 || session.isolationLevel == 8) {
                    session.tempSet.clear();
                    session.abortTransaction = session.deadlockRollback;
                    throw Error.error(4871);
                }
                if (row.rowAction != null && row.rowAction.isDeleted()) {
                    session.tempSet.clear();
                    session.redoAction = true;
                    ++this.redoCount;
                    throw Error.error(4871);
                }
                boolean bl = redoAction = !session.tempSet.isEmpty();
                if (redoAction) {
                    actionSession = ((RowActionBase)session.tempSet.get((int)0)).session;
                    session.tempSet.clear();
                    if (actionSession != null) {
                        redoAction = this.checkDeadlock(session, actionSession);
                    }
                }
                if (redoAction) {
                    session.redoAction = true;
                    if (actionSession != null) {
                        actionSession.waitingSessions.add(session);
                        session.waitedSessions.add(actionSession);
                        session.latch.countUp();
                    }
                } else {
                    session.redoAction = false;
                    session.abortTransaction = session.deadlockRollback;
                }
                ++this.redoCount;
                throw Error.error(4871);
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.writeLock.unlock();
                throw throwable;
            }
        }
        session.rowActionList.add(action);
        return action;
    }

    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        Session actionSession = null;
        boolean redoAction = false;
        boolean redoWait = true;
        if (action == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        if (table.tableType == 5) {
            this.rowActionMap.put(action.getPos(), action);
        }
        try {
            store.indexRow(session, row);
        }
        catch (HsqlException e) {
            if (session.tempSet.isEmpty()) {
                throw e;
            }
            redoAction = true;
        }
        if (!redoAction) {
            session.rowActionList.add(action);
            return;
        }
        this.writeLock.lock();
        try {
            this.rollbackAction(session);
            RowActionBase otherAction = (RowActionBase)session.tempSet.get(0);
            actionSession = otherAction.session;
            session.tempSet.clear();
            if (otherAction.commitTimestamp != 0L) {
                redoWait = false;
            }
            switch (session.isolationLevel) {
                default: 
            }
            redoAction = this.checkDeadlock(session, actionSession);
            if (redoAction) {
                session.redoAction = true;
                if (redoWait) {
                    actionSession.waitingSessions.add(session);
                    session.waitedSessions.add(actionSession);
                    session.latch.countUp();
                }
            } else {
                session.redoAction = false;
            }
            ++this.redoCount;
            throw Error.error(4871);
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public boolean canRead(Session session, Row row, int mode, int[] colMap) {
        RowAction action = row.rowAction;
        if (mode == 0) {
            if (action == null) {
                return true;
            }
            return action.canRead(session, 0);
        }
        if (mode == 2) {
            boolean result = action == null ? true : action.canRead(session, 0);
            return result;
        }
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    public boolean canRead(Session session, int id, int mode) {
        RowAction action = (RowAction)this.rowActionMap.get(id);
        if (action == null) {
            return true;
        }
        return action.canRead(session, mode);
    }

    public void setTransactionInfo(CachedObject object) {
        RowAction rowact;
        if (object.isMemory()) {
            return;
        }
        Row row = (Row)object;
        row.rowAction = rowact = (RowAction)this.rowActionMap.get(row.position);
    }

    public void removeTransactionInfo(CachedObject object) {
        if (object.isMemory()) {
            return;
        }
        this.rowActionMap.remove(object.getPos());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToCommittedQueue(Session session, Object[] list) {
        LongDeque longDeque = this.committedTransactionTimestamps;
        synchronized (longDeque) {
            this.committedTransactions.addLast(list);
            this.committedTransactionTimestamps.addLast(session.actionTimestamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeExpiredTransactions(Session session) {
        long timestamp = this.getFirstLiveTransactionTimestamp();
        while (true) {
            Object[] actions;
            long commitTimestamp;
            LongDeque longDeque = this.committedTransactionTimestamps;
            synchronized (longDeque) {
                if (this.committedTransactionTimestamps.isEmpty()) {
                    break;
                }
                commitTimestamp = this.committedTransactionTimestamps.getFirst();
                if (commitTimestamp >= timestamp) {
                    break;
                }
                this.committedTransactionTimestamps.removeFirst();
                actions = (Object[])this.committedTransactions.removeFirst();
            }
            this.mergeTransaction(session, actions, 0, actions.length, commitTimestamp);
            this.finaliseRows(session, actions, 0, actions.length, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginTransaction(Session session) {
        this.writeLock.lock();
        try {
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.transactionTimestamp);
                ++this.transactionCount;
            }
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void beginAction(Session session, Statement cs) {
        block8: {
            block7: {
                if (session.isTransaction) {
                    return;
                }
                if (cs == null) {
                    return;
                }
                this.writeLock.lock();
                try {
                    if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                        session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                        if (cs == null) {
                            Object var4_3 = null;
                            this.writeLock.unlock();
                            return;
                        }
                    }
                    session.isPreTransaction = true;
                    if (!this.isLockedMode && !cs.isCatalogChange()) {
                        break block7;
                    }
                    this.beingActionTPL(session, cs);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var4_4 = null;
            this.writeLock.unlock();
            return;
        }
        Object var4_5 = null;
        this.writeLock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginActionResume(Session session) {
        this.writeLock.lock();
        try {
            session.actionTimestamp = this.nextChangeTimestamp();
            if (!session.isTransaction) {
                session.transactionTimestamp = session.actionTimestamp;
                session.isTransaction = true;
                this.liveTransactionTimestamps.addLast(session.actionTimestamp);
                ++this.transactionCount;
            }
            session.isPreTransaction = false;
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RowAction addDeleteActionToRow(Session session, Table table, Row row, int[] colMap) {
        RowAction action = null;
        Row row2 = row;
        synchronized (row2) {
            if (table.tableType == 5) {
                Lock mapLock = this.rowActionMap.getWriteLock();
                mapLock.lock();
                try {
                    action = (RowAction)this.rowActionMap.get(row.getPos());
                    if (action == null) {
                        action = RowAction.addDeleteAction(session, table, row, colMap);
                        if (action != null) {
                            this.rowActionMap.put(row.getPos(), action);
                        }
                    } else {
                        row.rowAction = action;
                        action = RowAction.addDeleteAction(session, table, row, colMap);
                    }
                    Object var9_8 = null;
                    mapLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    mapLock.unlock();
                    throw throwable;
                }
            } else {
                action = RowAction.addDeleteAction(session, table, row, colMap);
            }
        }
        return action;
    }

    void endTransaction(Session session) {
        long timestamp = session.transactionTimestamp;
        int index = this.liveTransactionTimestamps.indexOf(timestamp);
        if (index >= 0) {
            --this.transactionCount;
            this.liveTransactionTimestamps.remove(index);
            this.mergeExpiredTransactions(session);
        }
    }

    public DoubleIntIndex getTransactionIDList() {
        return super.getTransactionIDList();
    }

    public void convertTransactionIDs(DoubleIntIndex lookup) {
        super.convertTransactionIDs(lookup);
    }

    private void countDownLatches(Session session) {
        for (int i = 0; i < session.waitingSessions.size(); ++i) {
            Session current = (Session)session.waitingSessions.get(i);
            current.waitedSessions.remove(session);
            current.latch.countDown();
        }
        session.waitingSessions.clear();
    }

    void getTransactionSessions(HashSet set) {
        Session[] sessions = this.database.sessionManager.getAllSessions();
        for (int i = 0; i < sessions.length; ++i) {
            long timestamp = sessions[i].getTransactionTimestamp();
            if (this.liveTransactionTimestamps.contains(timestamp)) {
                set.add(sessions[i]);
                continue;
            }
            if (sessions[i].isPreTransaction) {
                set.add(sessions[i]);
                continue;
            }
            if (!sessions[i].isTransaction) continue;
            set.add(sessions[i]);
        }
    }

    void endTransactionTPL(Session session) {
        Session current;
        int i;
        if (this.catalogWriteSession != session) {
            return;
        }
        Session nextSession = null;
        session.waitingSessions.size();
        for (i = 0; i < session.waitingSessions.size(); ++i) {
            current = (Session)session.waitingSessions.get(i);
            Statement st = current.sessionContext.currentStatement;
            if (st == null || !st.isCatalogChange()) continue;
            nextSession = current;
            break;
        }
        if (nextSession == null) {
            this.catalogWriteSession = null;
            this.isLockedMode = false;
        } else {
            for (i = 0; i < session.waitingSessions.size(); ++i) {
                current = (Session)session.waitingSessions.get(i);
                if (current == nextSession) continue;
                current.waitedSessions.add(nextSession);
                nextSession.waitingSessions.add(current);
                current.latch.countUp();
            }
            this.catalogWriteSession = nextSession;
        }
        this.unlockTxTs = session.actionTimestamp;
        this.unlockSessionId = session.getId();
    }

    boolean beingActionTPL(Session session, Statement cs) {
        boolean needsLock;
        if (cs == null) {
            return true;
        }
        if (session.abortTransaction) {
            return false;
        }
        session.tempSet.clear();
        if (cs.isCatalogChange() && this.catalogWriteSession == null) {
            this.catalogWriteSession = session;
            this.isLockedMode = true;
            this.lockTxTs = session.actionTimestamp;
            this.lockSessionId = session.getId();
            this.getTransactionSessions(session.tempSet);
            session.tempSet.remove(session);
            if (!session.tempSet.isEmpty()) {
                this.setWaitingSessionTPL(session);
            }
            return true;
        }
        if (!this.isLockedMode) {
            return true;
        }
        boolean bl = needsLock = cs.getTableNamesForRead().length > 0 || cs.getTableNamesForWrite().length > 0;
        if (!needsLock) {
            return true;
        }
        if (cs.getTableNamesForWrite().length > 0 ? cs.getTableNamesForWrite()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME : cs.getTableNamesForRead().length > 0 && cs.getTableNamesForRead()[0].schema == SqlInvariants.LOBS_SCHEMA_HSQLNAME) {
            return true;
        }
        this.catalogWriteSession.waitingSessions.add(session);
        session.waitedSessions.add(this.catalogWriteSession);
        session.latch.countUp();
        return true;
    }
}

