/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.Util;

public class JDBCDataSource
extends JDBCCommonDataSource
implements DataSource,
Serializable,
Referenceable {
    public Connection getConnection() throws SQLException {
        if (this.url == null) {
            throw Util.nullArgument("url");
        }
        if (this.connectionProps == null) {
            if (this.user == null) {
                throw Util.invalidArgument("user");
            }
            if (this.password == null) {
                throw Util.invalidArgument("password");
            }
            return this.getConnection(this.user, this.password);
        }
        if (this.connectionProps == null) {
            return this.getConnection(this.url, new Properties());
        }
        return this.getConnection(this.url, this.connectionProps);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        if (this.user == null) {
            throw Util.invalidArgument("user");
        }
        if (password == null) {
            throw Util.invalidArgument("password");
        }
        Properties props = new Properties();
        props.setProperty("user", username);
        props.setProperty("password", password);
        props.setProperty("loginTimeout", Integer.toString(this.loginTimeout));
        return this.getConnection(this.url, props);
    }

    private Connection getConnection(String url, Properties props) throws SQLException {
        if (!url.startsWith("jdbc:hsqldb:")) {
            url = "jdbc:hsqldb:" + url;
        }
        return JDBCDriver.getConnection(url, props);
    }

    public Reference getReference() throws NamingException {
        String cname = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference ref = new Reference(this.getClass().getName(), cname, null);
        ref.add(new StringRefAddr("database", this.getDatabase()));
        ref.add(new StringRefAddr("user", this.getUser()));
        ref.add(new StringRefAddr("password", this.password));
        ref.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return ref;
    }
}

