/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hsqldb.Session;
import org.hsqldb.result.Result;
import org.hsqldb.server.RecoverableOdbcFailure;
import org.hsqldb.server.StatementPortal;

class OdbcPreparedStatement {
    public String handle;
    public String query;
    public Result ackResult;
    public Session session;
    private Map containingMap;
    private List portals = new ArrayList();

    protected OdbcPreparedStatement(OdbcPreparedStatement other) {
        this.handle = other.handle;
        this.ackResult = other.ackResult;
    }

    public OdbcPreparedStatement(String handle, String query, Map containingMap, Session session) throws RecoverableOdbcFailure {
        this.handle = handle;
        this.query = query;
        this.containingMap = containingMap;
        this.session = session;
        Result psResult = Result.newPrepareStatementRequest();
        psResult.setPrepareOrExecuteProperties(query, 0, 0, 0, 0, 0, 2, null, null);
        this.ackResult = session.execute(psResult);
        switch (this.ackResult.getType()) {
            case 4: {
                break;
            }
            case 2: {
                throw new RecoverableOdbcFailure(this.ackResult);
            }
            default: {
                throw new RecoverableOdbcFailure("Output Result from Statement prep is of unexpected type: " + this.ackResult.getType());
            }
        }
        containingMap.put(handle, this);
    }

    public void close() {
        this.containingMap.remove(this.handle);
        while (this.portals.size() > 0) {
            ((StatementPortal)this.portals.remove(1)).close();
        }
    }

    public void addPortal(StatementPortal portal) {
        this.portals.add(portal);
    }
}

