/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.store;

import org.hsqldb.store.BaseHashMap;
import org.hsqldb.types.TimestampData;

public class ValuePoolHashMap
extends BaseHashMap {
    public ValuePoolHashMap(int initialCapacity, int maxCapacity, int purgePolicy) throws IllegalArgumentException {
        super(initialCapacity, 3, 0, true);
        this.maxCapacity = maxCapacity;
        this.purgePolicy = purgePolicy;
    }

    public void resetCapacity(int newCapacity, int newPolicy) throws IllegalArgumentException {
        if (newCapacity != 0 && this.hashIndex.elementCount > newCapacity) {
            int surplus = this.hashIndex.elementCount - newCapacity;
            if ((surplus += surplus >> 5) > this.hashIndex.elementCount) {
                surplus = this.hashIndex.elementCount;
            }
            this.clear(surplus, surplus >> 6);
        }
        if (newCapacity != 0 && newCapacity < this.threshold) {
            this.rehash(newCapacity);
            if (newCapacity < this.hashIndex.elementCount) {
                newCapacity = this.maxCapacity;
            }
        }
        this.maxCapacity = newCapacity;
        this.purgePolicy = newPolicy;
    }

    protected Integer getOrAddInteger(int intKey) {
        Integer testValue;
        int index = this.hashIndex.getHashIndex(intKey);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Integer)this.objectKeyTable[lookup];
            if (testValue == intKey) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddInteger(intKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Integer(intKey);
        this.objectKeyTable[lookup] = testValue;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return testValue;
    }

    protected Long getOrAddLong(long longKey) {
        Long testValue;
        int index = this.hashIndex.getHashIndex((int)(longKey ^ longKey >>> 32));
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Long)this.objectKeyTable[lookup];
            if (testValue == longKey) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddLong(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Long(longKey);
        this.objectKeyTable[lookup] = testValue;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return testValue;
    }

    protected String getOrAddString(Object key) {
        String testValue;
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (String)this.objectKeyTable[lookup];
            if (key.equals(testValue)) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(key);
        }
        testValue = key.toString();
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = testValue;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return testValue;
    }

    protected String getOrAddSubString(String key, int from, int limit) {
        String testValue;
        key = key.substring(from, limit);
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (String)this.objectKeyTable[lookup];
            if (key.equals(testValue)) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddString(key);
        }
        testValue = new String(key.toCharArray());
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = testValue;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return testValue;
    }

    protected TimestampData getOrAddDate(long longKey) {
        TimestampData testValue;
        int hash = (int)longKey ^ (int)(longKey >>> 32);
        int index = this.hashIndex.getHashIndex(hash);
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (TimestampData)this.objectKeyTable[lookup];
            if (testValue.getSeconds() == longKey) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDate(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new TimestampData(longKey);
        this.objectKeyTable[lookup] = testValue;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return testValue;
    }

    protected Double getOrAddDouble(long longKey) {
        Double testValue;
        int index = this.hashIndex.getHashIndex((int)(longKey ^ longKey >>> 32));
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            testValue = (Double)this.objectKeyTable[lookup];
            if (Double.doubleToLongBits(testValue) == longKey) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddDouble(longKey);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        testValue = new Double(Double.longBitsToDouble(longKey));
        this.objectKeyTable[lookup] = testValue;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return testValue;
    }

    protected Object getOrAddObject(Object key) {
        int index = this.hashIndex.getHashIndex(key.hashCode());
        int lookup = this.hashIndex.hashTable[index];
        int lastLookup = -1;
        while (lookup >= 0) {
            Object testValue = this.objectKeyTable[lookup];
            if (testValue.equals(key)) {
                if (this.accessCount > 0x7FEFFFFF) {
                    this.resetAccessCount();
                }
                ++this.accessCount;
                return testValue;
            }
            lastLookup = lookup;
            lookup = this.hashIndex.getNextLookup(lookup);
        }
        if (this.hashIndex.elementCount >= this.threshold) {
            this.reset();
            return this.getOrAddObject(key);
        }
        lookup = this.hashIndex.linkNode(index, lastLookup);
        this.objectKeyTable[lookup] = key;
        if (this.accessCount > 0x7FEFFFFF) {
            this.resetAccessCount();
        }
        ++this.accessCount;
        return key;
    }
}

