/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients;

import com.google.common.collect.Sets;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.axis.client.AxisClient;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientRuntime {
    private static Logger log = LoggerFactory.getLogger(ClientRuntime.class);
    private static final String LOGICAL_HOST_WSDD_PROPERTY = "logicalHost";
    private static final String LOGICAL_HOST_SYSTEM_PROPERTY = "gcube.client.hostname";
    public static final String location_property = "GLOBUS_LOCATION";
    private static final String installation_name = "ghn-client-distro";
    private static final String archive_name = "ghn-client-distro.zip";
    static final String mapConfigPattern = "ServiceMap_.*";

    public static synchronized void start() {
        String location = System.getProperty(location_property);
        if (location == null || !new File(location).exists()) {
            try {
                ClientRuntime.installDistro();
                ClientRuntime.installMaps();
                ClientRuntime.setLogicalHost();
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        try {
                            ClientRuntime.stop();
                        }
                        catch (Throwable t) {
                            log.warn("could not stop the client container and its services", t);
                        }
                    }
                });
            }
            catch (Throwable t) {
                throw new RuntimeException("could not start client runtime", t);
            }
        } else {
            log.info("using client runtime already at " + new File(location).getAbsolutePath());
        }
    }

    public static synchronized void stop() {
        try {
            new File(ClientRuntime.tempDir(), archive_name).delete();
            new File(ClientRuntime.tempDir(), installation_name).delete();
            log.info("stopped client runtime");
        }
        catch (Throwable t) {
            throw new RuntimeException("could not stop client runtime", t);
        }
    }

    private static File tempDir() throws Exception {
        File random = File.createTempFile("temp", null);
        File dir = random.getParentFile();
        random.delete();
        return dir;
    }

    private static void copy(InputStream in, File file) throws Exception {
        byte[] data = new byte[2048];
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        int read = 0;
        while ((read = in.read(data)) != -1) {
            out.write(data, 0, read);
        }
        out.flush();
        out.close();
        in.close();
    }

    private static void installDistro() throws Exception {
        InputStream embedded = ClientRuntime.class.getResourceAsStream("/ghn-client-distro.zip");
        File archive = new File(ClientRuntime.tempDir(), archive_name);
        ClientRuntime.copy(embedded, archive);
        ZipFile zipFile = new ZipFile(archive);
        Enumeration<? extends ZipEntry> zipFileEntries = zipFile.entries();
        while (zipFileEntries.hasMoreElements()) {
            ZipEntry entry = zipFileEntries.nextElement();
            File destFile = new File(ClientRuntime.tempDir(), entry.getName());
            if (entry.isDirectory()) {
                destFile.mkdirs();
                continue;
            }
            ClientRuntime.copy(zipFile.getInputStream(entry), destFile);
        }
        zipFile.close();
        String installation = new File(ClientRuntime.tempDir(), installation_name).getAbsolutePath();
        System.setProperty(location_property, installation);
        log.info("started client container in {}", (Object)installation);
    }

    private static void installMaps() {
        File configLocation = new File(System.getProperty(location_property), "config");
        try {
            ConfigurationBuilder builder = new ConfigurationBuilder().setUrls((Collection)ClasspathHelper.forManifest(ClientRuntime.urlsToScan())).setScanners(new Scanner[]{new ResourcesScanner()});
            Reflections reflections = new Reflections((Configuration)builder);
            for (String resource : reflections.getResources(Pattern.compile(mapConfigPattern))) {
                InputStream map = Thread.currentThread().getContextClassLoader().getResourceAsStream(resource);
                log.info("loading map {} ", (Object)resource);
                ClientRuntime.copy(map, new File(configLocation, resource));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("could not load service maps", e);
        }
    }

    private static Set<URL> urlsToScan() {
        HashSet result = Sets.newHashSet();
        for (ClassLoader classLoader = Thread.currentThread().getContextClassLoader(); classLoader != null && classLoader.getParent() != null; classLoader = classLoader.getParent()) {
            Object[] urls;
            if (!(classLoader instanceof URLClassLoader) || (urls = ((URLClassLoader)classLoader).getURLs()) == null) continue;
            result.addAll(Sets.newHashSet((Object[])urls));
        }
        return result;
    }

    private static void setLogicalHost() {
        try {
            String hostname = System.getProperty(LOGICAL_HOST_SYSTEM_PROPERTY);
            if (hostname == null) {
                hostname = InetAddress.getLocalHost().getHostName();
            }
            if (hostname == null) {
                throw new Exception("cannot determine local hostname. configure gcube.client.hostname.");
            }
            new AxisClient().getConfig().getGlobalOptions().put(LOGICAL_HOST_WSDD_PROPERTY, hostname);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

