/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.utils.encryption;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.utils.JavaUtils;

final class SymmetricKey {
    private static Map<String, Key> keys = new HashMap<String, Key>();
    private static String defaultKey = "/symm.key";
    private static String keyAlgorithm = "AES";

    private SymmetricKey() {
    }

    protected static Key getKey(String ... name) throws InvalidKeyException {
        if (name != null && name.length > 0) {
            if (!keys.containsKey(name[0])) {
                keys.put(name[0], SymmetricKey.load("/symm_" + name[0] + ".key"));
            }
            return keys.get(name[0]);
        }
        if (!keys.containsKey("DEFAULT")) {
            keys.put("DEFAULT", SymmetricKey.load(defaultKey));
        }
        return keys.get("DEFAULT");
    }

    private static Key load(String name) throws InvalidKeyException {
        byte[] rawKey;
        System.out.println("Loading key " + name);
        try {
            rawKey = JavaUtils.getBytesFromStream((InputStream)SymmetricKey.class.getResourceAsStream(name));
        }
        catch (Exception e) {
            System.out.println("Unable to load the Key from the classpath");
            e.printStackTrace();
            throw new InvalidKeyException();
        }
        try {
            return new SecretKeySpec(rawKey, 0, rawKey.length, keyAlgorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidKeyException();
        }
    }
}

