/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.transaction;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import net.sf.ehcache.transaction.ReadCommittedSoftLockFactoryImpl;
import net.sf.ehcache.transaction.SoftLock;
import net.sf.ehcache.transaction.TransactionException;
import net.sf.ehcache.transaction.TransactionID;

@IgnoreSizeOf
public class ReadCommittedSoftLockImpl
implements SoftLock {
    private static final int PRIME = 31;
    private final ReadCommittedSoftLockFactoryImpl factory;
    private final boolean wasPinned;
    private final ReentrantLock lock;
    private final ReentrantReadWriteLock freezeLock;
    private final String cacheManagerName;
    private final String cacheName;
    private final TransactionID transactionID;
    private final Object key;
    private Element newElement;
    private final Element oldElement;
    private volatile boolean expired;

    ReadCommittedSoftLockImpl(ReadCommittedSoftLockFactoryImpl factory, TransactionID transactionID, Object key, Element newElement, Element oldElement, boolean wasPinned) {
        this.factory = factory;
        this.wasPinned = wasPinned;
        this.cacheManagerName = factory.getCacheManagerName();
        this.cacheName = factory.getCacheName();
        this.transactionID = transactionID;
        this.key = key;
        this.newElement = newElement;
        this.oldElement = oldElement;
        this.lock = new ReentrantLock();
        this.freezeLock = new ReentrantReadWriteLock();
    }

    public Object getKey() {
        return this.key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getElement(TransactionID currentTransactionId) {
        this.freezeLock.readLock().lock();
        try {
            if (this.transactionID.equals(currentTransactionId)) {
                Element element = this.newElement;
                return element;
            }
            Element element = this.oldElement;
            return element;
        }
        finally {
            this.freezeLock.readLock().unlock();
        }
    }

    public Element updateElement(Element newElement) {
        Element e = this.newElement;
        this.newElement = newElement;
        return e;
    }

    public TransactionID getTransactionID() {
        return this.transactionID;
    }

    public boolean wasPinned() {
        return this.wasPinned;
    }

    public void lock() {
        this.lock.lock();
    }

    public boolean tryLock(long ms) throws InterruptedException {
        return this.lock.tryLock(ms, TimeUnit.MILLISECONDS);
    }

    public void clearTryLock() {
        this.lock.unlock();
    }

    public void unlock() {
        this.lock.unlock();
        this.clear();
    }

    private boolean isLocked() {
        return this.lock.isLocked();
    }

    public void freeze() {
        if (!this.isLocked()) {
            throw new IllegalStateException("cannot freeze an unlocked soft lock");
        }
        this.freezeLock.writeLock().lock();
    }

    public Element getFrozenElement() {
        if (!this.isFrozen()) {
            throw new IllegalStateException("cannot get frozen element of a soft lock which hasn't been frozen or hasn't expired");
        }
        if (this.transactionID.isDecisionCommit()) {
            return this.newElement;
        }
        return this.oldElement;
    }

    public void unfreeze() {
        this.freezeLock.writeLock().unlock();
    }

    private boolean isFrozen() {
        return this.freezeLock.isWriteLocked();
    }

    public boolean isExpired() {
        if (!this.expired) {
            this.expired = !this.isFrozen() && !this.isLocked();
        }
        return this.expired;
    }

    private void clear() {
        this.factory.clearSoftLock(this);
    }

    public boolean equals(Object object) {
        if (object instanceof ReadCommittedSoftLockImpl) {
            ReadCommittedSoftLockImpl other = (ReadCommittedSoftLockImpl)object;
            if (!this.transactionID.equals(other.transactionID)) {
                return false;
            }
            return this.key.equals(other.key);
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 31;
        hashCode *= this.transactionID.hashCode();
        return hashCode *= this.key.hashCode();
    }

    private Object writeReplace() throws ObjectStreamException {
        return new ReadCommittedSoftLockImplSerializedForm(this.cacheManagerName, this.cacheName, this.transactionID, this.key);
    }

    public String toString() {
        return "Soft Lock [clustered: false, isolation: rc, transactionID: " + this.transactionID + ", key: " + this.key + ", newElement: " + this.newElement + ", oldElement: " + this.oldElement + "]";
    }

    private static final class ReadCommittedSoftLockImplSerializedForm
    implements Serializable {
        private final String cacheManagerName;
        private final String cacheName;
        private final TransactionID transactionID;
        private final Object key;

        private ReadCommittedSoftLockImplSerializedForm(String cacheManagerName, String cacheName, TransactionID transactionID, Object key) {
            this.cacheManagerName = cacheManagerName;
            this.cacheName = cacheName;
            this.transactionID = transactionID;
            this.key = key;
        }

        private Object readResolve() throws ObjectStreamException {
            for (int i = 0; i < CacheManager.ALL_CACHE_MANAGERS.size(); ++i) {
                CacheManager cacheManager = CacheManager.ALL_CACHE_MANAGERS.get(i);
                if (!cacheManager.getName().equals(this.cacheManagerName)) continue;
                try {
                    ReadCommittedSoftLockFactoryImpl softLockFactory = (ReadCommittedSoftLockFactoryImpl)cacheManager.getSoftLockFactory(this.cacheName);
                    return softLockFactory.getLock(this.transactionID, this.key);
                }
                catch (CacheException ce) {
                    throw new TransactionException("cannot deserialize SoftLock from cache " + this.cacheName + " as the cache cannot be found in cache manager " + this.cacheManagerName);
                }
            }
            throw new TransactionException("unable to find referent SoftLock in " + this.cacheManagerName + " " + this.cacheName + " for key [" + this.key + "] under transaction " + this.transactionID);
        }
    }
}

