/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.container;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.MessageContext;
import org.apache.axis.configuration.DirProvider;
import org.apache.axis.server.AxisServer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.config.ContainerConfig;
import org.globus.wsrf.container.BaseContainerConfig;
import org.globus.wsrf.container.Semaphore;
import org.globus.wsrf.container.ServiceHost;
import org.globus.wsrf.container.ServiceManager;
import org.globus.wsrf.container.ServiceRequest;
import org.globus.wsrf.container.ServiceRequestQueue;
import org.globus.wsrf.container.ServiceThread;
import org.globus.wsrf.container.ServiceThreadPool;
import org.globus.wsrf.container.UsageConfig;
import org.globus.wsrf.impl.security.descriptor.ContainerSecurityDescriptor;
import org.globus.wsrf.utils.Resources;

public class ServiceDispatcher
implements Runnable {
    static Log logger = LogFactory.getLog((String)ServiceDispatcher.class.getName());
    static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private ServerSocket serverSocket;
    private volatile Thread worker = null;
    private volatile boolean stopped = false;
    private Semaphore semaphore = new Semaphore();
    protected ServiceRequestQueue queue;
    protected ServiceThreadPool threadPool;
    protected int numThreads;
    protected int maxThreads;
    protected int highWaterMark;
    protected AxisServer engine;
    protected MessageContext msgContext;
    protected ContainerSecurityDescriptor containerDescriptor;
    private String homeDir;
    private String configDir;
    private String configProfile;

    protected ServiceDispatcher() {
    }

    public ServiceDispatcher(Map properties) throws Exception {
        String configFile = (String)properties.get("container.server.config");
        configFile = configFile == null ? "server-config.wsdd" : configFile;
        this.configProfile = (String)properties.get("config.profile");
        if (this.configProfile != null) {
            configFile = this.configProfile + "-" + configFile;
        }
        String baseDir = ContainerConfig.getGlobusLocation() + File.separator + "etc";
        this.engine = new AxisServer((EngineConfiguration)new DirProvider(baseDir, configFile));
        this.configDir = ServiceThread.getConfigRootPath((AxisEngine)this.engine);
        this.homeDir = ServiceThread.getWebRootPath((AxisEngine)this.engine);
        BaseContainerConfig.setEngine(this.engine);
        BaseContainerConfig.setBaseDirectory(this.configDir);
        BaseContainerConfig.setSchemaDirectory(this.homeDir);
        this.msgContext = this.createMessageContext();
        UsageConfig.setContainerType((short)1);
        this.containerDescriptor = (ContainerSecurityDescriptor)properties.get("container.descriptor");
        this.numThreads = -1;
    }

    protected void init() throws Exception {
        ContainerConfig config = ContainerConfig.getConfig((AxisEngine)this.engine);
        String host = ServiceHost.getHost(config);
        String serverID = System.getProperty("org.globus.wsrf.container.server.id");
        if (serverID == null && (serverID = config.getOption("server.id")) == null) {
            serverID = host + "-" + ServiceHost.getPort(null);
        }
        BaseContainerConfig.setContainerID(serverID);
        ServiceManager.getServiceManager(this.engine).start(this.msgContext);
        this.queue = new ServiceRequestQueue();
        this.setupThreadPool();
    }

    protected MessageContext createMessageContext() {
        MessageContext msgContext = new MessageContext((AxisEngine)this.engine);
        msgContext.setProperty("home.dir", (Object)this.homeDir);
        msgContext.setProperty("configPath", (Object)this.configDir);
        if (this.configProfile != null) {
            msgContext.setProperty("config.profile", (Object)this.configProfile);
        }
        return msgContext;
    }

    protected void setupThreadPool() throws Exception {
        this.threadPool = new ServiceThreadPool(this);
    }

    public AxisEngine getAxisEngine() {
        return this.engine;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setThreads(int numThreads) {
        this.numThreads = numThreads;
    }

    public ServiceThreadPool getServiceThreadPool() {
        return this.threadPool;
    }

    public ServiceRequestQueue getServiceRequestQueue() {
        return this.queue;
    }

    private static int getOptionAsInt(ContainerConfig config, String property, int defaultValue) {
        String value = config.getOption(property);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            logger.error((Object)i18n.getMessage("configError", (Object)property), (Throwable)e);
            return defaultValue;
        }
    }

    public void run() {
        ContainerConfig config = ContainerConfig.getConfig((AxisEngine)this.engine);
        int timeout = ServiceDispatcher.getOptionAsInt(config, "containerTimeout", 180000);
        if (this.numThreads <= 0) {
            this.numThreads = ServiceDispatcher.getOptionAsInt(config, "containerThreads", 0);
            this.maxThreads = ServiceDispatcher.getOptionAsInt(config, "containerThreadsMax", 0);
            this.highWaterMark = ServiceDispatcher.getOptionAsInt(config, "containerThreadsHighWaterMark", 0);
        }
        if (this.numThreads < 1) {
            this.numThreads = 1;
        }
        if (this.maxThreads == 0) {
            this.maxThreads = this.numThreads * 4;
        }
        if (this.highWaterMark == 0) {
            this.highWaterMark = this.numThreads * 2;
        }
        logger.debug((Object)("Starting up container with " + this.numThreads + " threads"));
        this.threadPool.startThreads(this.numThreads);
        this.semaphore.sendSignal();
        int addedThreads = 0;
        int acceptError = 0;
        while (!this.isStopped()) {
            Socket socket = null;
            try {
                socket = this.serverSocket.accept();
            }
            catch (IOException ioe) {
                if (this.isStopped()) break;
                logger.error((Object)i18n.getMessage("serviceDispatcherAcceptError01"), (Throwable)ioe);
                if (acceptError > 0) {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {}
                    continue;
                }
                ++acceptError;
                continue;
            }
            acceptError = 0;
            try {
                socket.setSoTimeout(timeout);
            }
            catch (SocketException e) {
                logger.warn((Object)i18n.getMessage("soTimeoutFailed"), (Throwable)e);
            }
            int waitingThreads = this.queue.enqueue(new ServiceRequest(socket, this.serverSocket));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("waiting threads: " + waitingThreads));
            }
            if (waitingThreads == 0 && this.threadPool.getThreads() < this.maxThreads) {
                addedThreads += this.addThread();
                continue;
            }
            if (waitingThreads <= this.highWaterMark || addedThreads <= 0) continue;
            this.removeThread();
            --addedThreads;
        }
    }

    public void waitForInit() throws InterruptedException {
        this.semaphore.waitForSignal();
    }

    public void waitForStop() throws InterruptedException {
        this.threadPool.waitForThreads();
    }

    private synchronized int addThread() {
        if (this.stopped) {
            return 0;
        }
        this.threadPool.startThreads(1);
        logger.debug((Object)"added thread");
        return 1;
    }

    private void removeThread() {
        this.threadPool.stopThreads(1);
        logger.debug((Object)"removed thread");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() throws IOException {
        if (this.stopped) {
            return;
        }
        logger.debug((Object)"Stopping dispatcher");
        this.stopped = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        finally {
            if (this.threadPool != null) {
                this.threadPool.stopThreads();
                try {
                    this.threadPool.waitForThreads(120000);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.engine != null) {
                ServiceManager.getServiceManager(this.engine).stop();
                this.engine.cleanup();
            }
            logger.debug((Object)"Stopped dispatcher");
        }
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public void start(boolean daemon) {
        this.worker = new Thread(this);
        this.worker.setName("ServiceDispacher" + this.worker.getName());
        this.worker.setDaemon(daemon);
        this.worker.start();
    }
}

