/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl;

import java.lang.reflect.Method;
import java.util.Calendar;
import javax.xml.namespace.QName;
import org.apache.axis.description.ElementDesc;
import org.apache.axis.description.FieldDesc;
import org.apache.axis.description.TypeDesc;
import org.apache.axis.utils.cache.MethodCache;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceException;
import org.globus.wsrf.ResourceIdentifier;
import org.globus.wsrf.ResourceLifetime;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertyMetaData;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.WSRFConstants;
import org.globus.wsrf.impl.ReflectionResourceProperty;
import org.globus.wsrf.impl.SimpleResourcePropertyMetaData;
import org.globus.wsrf.impl.SimpleResourcePropertySet;
import org.globus.wsrf.utils.Resources;

public class ReflectionResource
implements Resource,
ResourceProperties,
ResourceIdentifier,
ResourceLifetime {
    private static Log logger = LogFactory.getLog((String)ReflectionResource.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());
    private static final Class[] SET_TERM_TIME_PARAM = new Class[]{Calendar.class};
    private static MethodCache methodCache = MethodCache.getInstance();
    private ResourcePropertySet resourcePropertySet;
    private Object ID;
    private Object resourceBean;
    private Method setTerminationTimeMethod;
    private Method getTerminationTimeMethod;
    static /* synthetic */ Class class$java$lang$Object;

    public void initialize(Object resourceBean, QName resourceElementQName, Object key) throws ResourceException {
        if (key == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"key"));
        }
        this.ID = key;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("class of key passed to resource:" + key.getClass().getName()));
            logger.debug((Object)("class of implementation bean passed to resource:" + resourceBean.getClass().getName()));
        }
        this.initializeResourceProperties(resourceBean, resourceElementQName);
    }

    private void initializeResourceProperties(Object resourceBean, QName resourceElementQName) throws ResourceException {
        if (resourceBean == null) {
            throw new IllegalArgumentException(i18n.getMessage("nullArgument", (Object)"resourceBean"));
        }
        this.resourceBean = resourceBean;
        Class<?> resourceBeanClazz = resourceBean.getClass();
        TypeDesc typeDesc = TypeDesc.getTypeDescForClass(resourceBeanClazz);
        if (typeDesc == null) {
            throw new ResourceException(i18n.getMessage("noTypeDesc", resourceBeanClazz));
        }
        String localTypeName = typeDesc.getXmlType().getLocalPart();
        if (localTypeName.startsWith(">")) {
            String globalElementName = localTypeName.substring(1);
            if (resourceElementQName == null) {
                resourceElementQName = new QName(typeDesc.getXmlType().getNamespaceURI(), globalElementName);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("QName of global element for resource properties is:" + resourceElementQName));
        }
        FieldDesc[] fields = typeDesc.getFields();
        this.resourcePropertySet = new SimpleResourcePropertySet(resourceElementQName);
        ResourceProperty prop = null;
        try {
            for (int i = 0; i < fields.length; ++i) {
                QName rpQName = fields[i].getXmlName();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("creating new resource property \"" + rpQName.toString() + "\""));
                }
                if (!(fields[i] instanceof ElementDesc)) {
                    String errorMessage = i18n.getMessage("rpNotElement", (Object)fields[i].getXmlType().getLocalPart());
                    throw new ResourceException(errorMessage);
                }
                ElementDesc elementDesc = (ElementDesc)fields[i];
                SimpleResourcePropertyMetaData metaData = new SimpleResourcePropertyMetaData(rpQName, elementDesc.getMinOccurs(), elementDesc.getMaxOccurs(), false, class$java$lang$Object == null ? ReflectionResource.class$("java.lang.Object") : class$java$lang$Object, false);
                prop = this.createNewResourceProperty(metaData, this.resourceBean);
                this.resourcePropertySet.add(prop);
            }
        }
        catch (ResourceException e) {
            logger.error((Object)"", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new ResourceException(i18n.getMessage("resourceInitError"), e);
        }
    }

    protected ResourceProperty createNewResourceProperty(QName rpQName, Object resourceBean) throws Exception {
        return this.createNewResourceProperty(new SimpleResourcePropertyMetaData(rpQName), resourceBean);
    }

    protected ResourceProperty createNewResourceProperty(ResourcePropertyMetaData metaData, Object resourceBean) throws Exception {
        Object resourceBeanCallback = resourceBean;
        QName rpQName = metaData.getName();
        ReflectionResourceProperty prop = null;
        if (rpQName.equals(WSRFConstants.TERMINATION_TIME)) {
            prop = new ReflectionResourceProperty(SimpleResourcePropertyMetaData.TERMINATION_TIME, resourceBeanCallback);
            this.setTerminationTimeMethod = methodCache.getMethod(resourceBeanCallback.getClass(), "setTerminationTime", SET_TERM_TIME_PARAM);
            this.getTerminationTimeMethod = methodCache.getMethod(resourceBeanCallback.getClass(), "getTerminationTime", null);
        } else {
            prop = rpQName.equals(WSRFConstants.CURRENT_TIME) ? new ReflectionResourceProperty(SimpleResourcePropertyMetaData.CURRENT_TIME, (Object)this) : new ReflectionResourceProperty(metaData, resourceBeanCallback);
        }
        return prop;
    }

    public void setTerminationTime(Calendar time) {
        if (this.setTerminationTimeMethod != null) {
            try {
                this.setTerminationTimeMethod.invoke(this.getResourceBean(), time);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
    }

    public Calendar getTerminationTime() {
        if (this.getTerminationTimeMethod != null) {
            try {
                return (Calendar)this.getTerminationTimeMethod.invoke(this.getResourceBean(), null);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new RuntimeException(e.getMessage());
            }
        }
        return null;
    }

    public Calendar getCurrentTime() {
        return Calendar.getInstance();
    }

    public ResourcePropertySet getResourcePropertySet() {
        return this.resourcePropertySet;
    }

    public Object getID() {
        return this.ID;
    }

    public Object getResourceBean() {
        return this.resourceBean;
    }
}

