/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.properties;

import java.rmi.RemoteException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.axis.encoding.AnyContentType;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.ResourceProperties;
import org.globus.wsrf.ResourceProperty;
import org.globus.wsrf.ResourcePropertySet;
import org.globus.wsrf.utils.AnyHelper;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsrf.faults.BaseFaultType;
import org.oasis.wsrf.properties.GetMultipleResourcePropertiesResponse;
import org.oasis.wsrf.properties.GetMultipleResourceProperties_Element;
import org.oasis.wsrf.properties.InvalidResourcePropertyQNameFaultType;
import org.oasis.wsrf.properties.ResourceUnknownFaultType;

public class GetMultipleResourcePropertiesProvider {
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());

    public GetMultipleResourcePropertiesResponse getMultipleResourceProperties(GetMultipleResourceProperties_Element request) throws RemoteException, InvalidResourcePropertyQNameFaultType, ResourceUnknownFaultType {
        if (request == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("nullArgument", (Object)"request"));
            throw fault;
        }
        QName[] qnames = request.getResourceProperty();
        if (qnames == null) {
            InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("noRPNames"));
            throw fault;
        }
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (NoSuchResourceException e) {
            ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("resourceDisoveryFailed"), e);
        }
        if (!(resource instanceof ResourceProperties)) {
            throw new RemoteException(i18n.getMessage("rpsNotSupported"));
        }
        ResourcePropertySet set = ((ResourceProperties)((Object)resource)).getResourcePropertySet();
        ArrayList<SOAPElement> list = new ArrayList<SOAPElement>();
        for (int i = 0; i < qnames.length; ++i) {
            SOAPElement[] rp;
            ResourceProperty prop = set.get(qnames[i]);
            if (prop == null) {
                InvalidResourcePropertyQNameFaultType fault = new InvalidResourcePropertyQNameFaultType();
                FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
                faultHelper.setDescription(qnames[i].toString());
                throw fault;
            }
            try {
                rp = prop.toSOAPElements();
            }
            catch (Exception e) {
                throw new RemoteException(i18n.getMessage("rpSerializationError", (Object)prop), e);
            }
            if (rp == null) continue;
            for (int j = 0; j < rp.length; ++j) {
                list.add(rp[j]);
            }
        }
        GetMultipleResourcePropertiesResponse response = new GetMultipleResourcePropertiesResponse();
        AnyHelper.setAny((AnyContentType)response, list);
        return response;
    }
}

