/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.ac;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AttCertValidityPeriod;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.glite.security.voms.ac.AttCertIssuer;
import org.glite.security.voms.ac.Holder;

public class AttributeCertificateInfo
implements DEREncodable {
    DERInteger version;
    Holder holder;
    AttCertIssuer issuer;
    AlgorithmIdentifier signature;
    DERInteger serialNumber;
    AttCertValidityPeriod attrCertValidityPeriod;
    ASN1Sequence attributes;
    DERBitString issuerUniqueID;
    X509Extensions extensions;
    boolean badVomsEncoding = false;

    public AttributeCertificateInfo(ASN1Sequence seq) {
        ASN1Sequence s2;
        this.version = (DERInteger)seq.getObjectAt(0);
        this.holder = new Holder((ASN1Sequence)seq.getObjectAt(1));
        this.issuer = new AttCertIssuer(seq.getObjectAt(2));
        this.signature = new AlgorithmIdentifier((ASN1Sequence)seq.getObjectAt(3));
        this.serialNumber = (DERInteger)seq.getObjectAt(4);
        ASN1Sequence s3 = s2 = (ASN1Sequence)seq.getObjectAt(5);
        if (s2.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.badVomsEncoding = true;
            DEREncodableVector v = new DEREncodableVector();
            for (int i = 0; i < 2; ++i) {
                byte[] bb = ((DEROctetString)((ASN1TaggedObject)s2.getObjectAt(i)).getObject()).getOctets();
                v.add((DEREncodable)new DERGeneralizedTime(new String(bb)));
            }
            s3 = new DERSequence(v);
        }
        this.attrCertValidityPeriod = new AttCertValidityPeriod(s3);
        this.attributes = (ASN1Sequence)seq.getObjectAt(6);
        if (seq.size() > 8) {
            this.issuerUniqueID = new DERBitString(seq.getObjectAt(7));
            this.extensions = new X509Extensions((ASN1Sequence)seq.getObjectAt(8));
        } else if (seq.size() > 7) {
            this.extensions = new X509Extensions((ASN1Sequence)seq.getObjectAt(7));
        }
    }

    public static AttributeCertificateInfo getInstance(ASN1Sequence seq) {
        return new AttributeCertificateInfo(seq);
    }

    public DERInteger getAttCertVersion() {
        return this.version;
    }

    public Holder getHolder() {
        return this.holder;
    }

    public AttCertIssuer getIssuer() {
        return this.issuer;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public DERInteger getSerialNumber() {
        return this.serialNumber;
    }

    public AttCertValidityPeriod getAttrCertValidityPeriod() {
        return this.attrCertValidityPeriod;
    }

    public ASN1Sequence getAttributes() {
        return this.attributes;
    }

    public DERBitString getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public X509Extensions getExtensions() {
        return this.extensions;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((DEREncodable)this.version);
        v.add((DEREncodable)this.holder);
        v.add((DEREncodable)this.issuer);
        v.add((DEREncodable)this.signature);
        v.add((DEREncodable)this.serialNumber);
        if (!this.badVomsEncoding) {
            v.add((DEREncodable)this.attrCertValidityPeriod);
        } else {
            DEREncodableVector v2 = new DEREncodableVector();
            v2.add((DEREncodable)new DERTaggedObject(false, 0, (DEREncodable)new DEROctetString((this.attrCertValidityPeriod.getNotBeforeTime().getTime().substring(0, 14) + "Z").getBytes())));
            v2.add((DEREncodable)new DERTaggedObject(false, 1, (DEREncodable)new DEROctetString((this.attrCertValidityPeriod.getNotAfterTime().getTime().substring(0, 14) + "Z").getBytes())));
            v.add((DEREncodable)new DERSequence(v2));
        }
        v.add((DEREncodable)this.attributes);
        if (this.issuerUniqueID != null) {
            v.add((DEREncodable)this.issuerUniqueID);
        }
        if (this.extensions != null) {
            v.add((DEREncodable)this.extensions);
        }
        return new DERSequence((DEREncodableVector)v);
    }
}

