/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.async;

import java.io.IOException;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.async.AsyncDataManager;
import org.apache.activemq.kaha.impl.async.Location;
import org.apache.activemq.kaha.impl.data.RedoListener;
import org.apache.activemq.util.ByteSequence;
import org.apache.activemq.util.DataByteArrayInputStream;
import org.apache.activemq.util.DataByteArrayOutputStream;

public final class DataManagerFacade
implements DataManager {
    private static final ByteSequence FORCE_COMMAND = new ByteSequence(new byte[]{70, 79, 82, 67, 69});
    private AsyncDataManager dataManager;
    private final String name;
    private Marshaller redoMarshaller;

    public DataManagerFacade(AsyncDataManager dataManager, String name) {
        this.dataManager = dataManager;
        this.name = name;
    }

    private static StoreLocation convertToStoreLocation(Location location) {
        if (location == null) {
            return null;
        }
        return new StoreLocationFacade(location);
    }

    private static Location convertFromStoreLocation(StoreLocation location) {
        if (location == null) {
            return null;
        }
        if (location.getClass() == StoreLocationFacade.class) {
            return ((StoreLocationFacade)location).getLocation();
        }
        Location l = new Location();
        l.setOffset((int)location.getOffset());
        l.setSize(location.getSize());
        l.setDataFileId(location.getFile());
        return l;
    }

    public Object readItem(Marshaller marshaller, StoreLocation location) throws IOException {
        ByteSequence sequence = this.dataManager.read(DataManagerFacade.convertFromStoreLocation(location));
        DataByteArrayInputStream dataIn = new DataByteArrayInputStream(sequence);
        return marshaller.readPayload(dataIn);
    }

    public StoreLocation storeDataItem(Marshaller marshaller, Object payload) throws IOException {
        DataByteArrayOutputStream buffer = new DataByteArrayOutputStream();
        marshaller.writePayload(payload, buffer);
        ByteSequence data = buffer.toByteSequence();
        return DataManagerFacade.convertToStoreLocation(this.dataManager.write(data, (byte)1, false));
    }

    public void force() throws IOException {
        this.dataManager.write(FORCE_COMMAND, (byte)2, true);
    }

    public void updateItem(StoreLocation location, Marshaller marshaller, Object payload) throws IOException {
        DataByteArrayOutputStream buffer = new DataByteArrayOutputStream();
        marshaller.writePayload(payload, buffer);
        ByteSequence data = buffer.toByteSequence();
        this.dataManager.update(DataManagerFacade.convertFromStoreLocation(location), data, false);
    }

    public void close() throws IOException {
        this.dataManager.close();
    }

    public void consolidateDataFiles() throws IOException {
        this.dataManager.consolidateDataFiles();
    }

    public boolean delete() throws IOException {
        return this.dataManager.delete();
    }

    public void addInterestInFile(int file) throws IOException {
        this.dataManager.addInterestInFile(file);
    }

    public void removeInterestInFile(int file) throws IOException {
        this.dataManager.removeInterestInFile(file);
    }

    public void recoverRedoItems(RedoListener listener) throws IOException {
        throw new RuntimeException("Not Implemented..");
    }

    public StoreLocation storeRedoItem(Object payload) throws IOException {
        throw new RuntimeException("Not Implemented..");
    }

    public Marshaller getRedoMarshaller() {
        return this.redoMarshaller;
    }

    public void setRedoMarshaller(Marshaller redoMarshaller) {
        this.redoMarshaller = redoMarshaller;
    }

    public String getName() {
        return this.name;
    }

    private static class StoreLocationFacade
    implements StoreLocation {
        private final Location location;

        public StoreLocationFacade(Location location) {
            this.location = location;
        }

        public int getFile() {
            return this.location.getDataFileId();
        }

        public long getOffset() {
            return this.location.getOffset();
        }

        public int getSize() {
            return this.location.getSize();
        }

        public Location getLocation() {
            return this.location;
        }
    }
}

