/*
 * Decompiled with CFR 0.152.
 */
package org.globus.tomcat.catalina.valves;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;
import org.globus.tomcat.catalina.net.GSISocket;

public final class CertificatesValve
extends ValveBase
implements Lifecycle {
    protected boolean certificates = false;
    protected int debug = 0;
    protected static final String info = "org.globus.tomcat.catalina.valves.CertificatesValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    protected static StringManager sm = StringManager.getManager((String)"org.apache.catalina.valves");
    protected boolean started = false;

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        Request actual = request;
        if (this.certificates) {
            this.verify(request, actual);
        }
        this.expose(request, actual);
        context.invokeNext(request, response);
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return new LifecycleListener[0];
    }

    public void start() throws LifecycleException {
        String authMethod;
        Context context;
        LoginConfig loginConfig;
        if (this.started) {
            throw new LifecycleException(sm.getString("certificatesValve.alreadyStarted"));
        }
        this.started = true;
        if (this.debug >= 1) {
            this.log("Starting");
        }
        this.certificates = false;
        if (this.container instanceof Context && (loginConfig = (context = (Context)this.container).getLoginConfig()) != null && "CLIENT-CERT".equalsIgnoreCase(authMethod = loginConfig.getAuthMethod())) {
            this.certificates = true;
        }
        this.lifecycle.fireLifecycleEvent("start", null);
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("certificatesValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        if (this.debug >= 1) {
            this.log("Stopping");
        }
        this.certificates = false;
    }

    protected void expose(Request request, Request actual) {
        if (actual.getSocket() == null) {
            return;
        }
        if (!(actual.getSocket() instanceof GSISocket)) {
            return;
        }
        if (this.debug >= 2) {
            this.log(" expose: It's a GSI socket");
        }
        GSISocket socket = (GSISocket)((Object)actual.getSocket());
        Object tmp = null;
        tmp = socket.getDelegatedCredentials();
        if (tmp != null) {
            request.getRequest().setAttribute("org.globus.gsi.credentials", tmp);
        }
        if ((tmp = socket.getAuthorizedUserName()) != null) {
            request.getRequest().setAttribute("org.globus.gsi.authorized.user.name", tmp);
        }
        if ((tmp = socket.getAuthorizedUserDN()) != null) {
            request.getRequest().setAttribute("org.globus.gsi.authorized.user.dn", tmp);
        }
    }

    protected void log(String message) {
        if (this.container != null && this.container.getLogger() != null) {
            Logger logger = this.container.getLogger();
            logger.log("CertificatesValve[" + this.container.getName() + "]: " + message);
        } else {
            System.out.println("CertificatesValve: " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        if (this.container != null && this.container.getLogger() != null) {
            Logger logger = this.container.getLogger();
            logger.log("CertificatesValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            System.out.println("CertificatesValve: " + message);
            throwable.printStackTrace(System.out);
        }
    }

    protected void verify(Request request, Request actual) {
    }
}

