/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.statistics;

import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.statistics.CacheUsageListener;
import net.sf.ehcache.statistics.LiveCacheStatistics;
import net.sf.ehcache.statistics.LiveCacheStatisticsData;
import net.sf.ehcache.statistics.LiveCacheStatisticsImpl;
import net.sf.ehcache.statistics.NullLiveCacheStatisticsData;

public class LiveCacheStatisticsWrapper
implements LiveCacheStatistics,
LiveCacheStatisticsData {
    private static final LiveCacheStatistics NULL_LIVE_CACHE_STATISTICS = new NullLiveCacheStatisticsData();
    private final LiveCacheStatisticsImpl liveDelegate;
    private volatile LiveCacheStatistics delegate;

    public LiveCacheStatisticsWrapper(Ehcache cache) {
        this.liveDelegate = new LiveCacheStatisticsImpl(cache);
        this.setStatisticsEnabled(true);
    }

    public void setStatisticsEnabled(boolean enableStatistics) {
        this.delegate = enableStatistics ? this.liveDelegate : NULL_LIVE_CACHE_STATISTICS;
    }

    public boolean isStatisticsEnabled() {
        return this.delegate instanceof LiveCacheStatisticsImpl;
    }

    public void registerCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.liveDelegate.registerCacheUsageListener(cacheUsageListener);
    }

    public void removeCacheUsageListener(CacheUsageListener cacheUsageListener) throws IllegalStateException {
        this.liveDelegate.removeCacheUsageListener(cacheUsageListener);
    }

    public void setStatisticsAccuracy(int statisticsAccuracy) {
        this.liveDelegate.setStatisticsAccuracy(statisticsAccuracy);
    }

    public int getStatisticsAccuracy() {
        return this.liveDelegate.getStatisticsAccuracy();
    }

    public String getStatisticsAccuracyDescription() {
        return this.liveDelegate.getStatisticsAccuracyDescription();
    }

    public String getCacheName() {
        return this.liveDelegate.getCacheName();
    }

    public long getSize() {
        return this.delegate.getSize();
    }

    @Deprecated
    public long getInMemorySize() {
        return this.delegate.getInMemorySize();
    }

    @Deprecated
    public long getOffHeapSize() {
        return this.delegate.getOffHeapSize();
    }

    @Deprecated
    public long getOnDiskSize() {
        return this.delegate.getOnDiskSize();
    }

    public long getLocalHeapSize() {
        return this.delegate.getLocalHeapSize();
    }

    public long getLocalOffHeapSize() {
        return this.delegate.getLocalOffHeapSize();
    }

    public long getLocalDiskSize() {
        return this.delegate.getLocalDiskSize();
    }

    public long getLocalHeapSizeInBytes() {
        return this.delegate.getLocalHeapSizeInBytes();
    }

    public long getLocalOffHeapSizeInBytes() {
        return this.delegate.getLocalOffHeapSizeInBytes();
    }

    public long getLocalDiskSizeInBytes() {
        return this.delegate.getLocalDiskSizeInBytes();
    }

    public float getAverageGetTimeMillis() {
        return this.delegate.getAverageGetTimeMillis();
    }

    public long getCacheHitCount() {
        return this.delegate.getCacheHitCount();
    }

    public long getCacheMissCount() {
        return this.delegate.getCacheMissCount();
    }

    public long getInMemoryMissCount() {
        return this.delegate.getInMemoryMissCount();
    }

    public long getOffHeapMissCount() {
        return this.delegate.getOffHeapMissCount();
    }

    public long getOnDiskMissCount() {
        return this.delegate.getOnDiskMissCount();
    }

    public long getCacheMissCountExpired() {
        return this.delegate.getCacheMissCountExpired();
    }

    public long getEvictedCount() {
        return this.delegate.getEvictedCount();
    }

    public long getExpiredCount() {
        return this.delegate.getExpiredCount();
    }

    public long getInMemoryHitCount() {
        return this.delegate.getInMemoryHitCount();
    }

    public long getOffHeapHitCount() {
        return this.delegate.getOffHeapHitCount();
    }

    public long getOnDiskHitCount() {
        return this.delegate.getOnDiskHitCount();
    }

    public long getPutCount() {
        return this.delegate.getPutCount();
    }

    public long getRemovedCount() {
        return this.delegate.getRemovedCount();
    }

    public long getUpdateCount() {
        return this.delegate.getUpdateCount();
    }

    private LiveCacheStatisticsData getDelegateAsLiveStatisticsData() {
        return (LiveCacheStatisticsData)((Object)this.delegate);
    }

    public void addGetTimeMillis(long millis) {
        this.getDelegateAsLiveStatisticsData().addGetTimeMillis(millis);
    }

    public long getMaxGetTimeMillis() {
        return this.delegate.getMaxGetTimeMillis();
    }

    public long getXaCommitCount() {
        return this.delegate.getXaCommitCount();
    }

    public long getXaRollbackCount() {
        return this.delegate.getXaRollbackCount();
    }

    public long getWriterQueueLength() {
        return this.delegate.getWriterQueueLength();
    }

    public long getMinGetTimeMillis() {
        return this.delegate.getMinGetTimeMillis();
    }

    public void cacheHitInMemory() {
        this.getDelegateAsLiveStatisticsData().cacheHitInMemory();
    }

    public void cacheHitOffHeap() {
        this.getDelegateAsLiveStatisticsData().cacheHitOffHeap();
    }

    public void cacheHitOnDisk() {
        this.getDelegateAsLiveStatisticsData().cacheHitOnDisk();
    }

    public void cacheMissExpired() {
        this.getDelegateAsLiveStatisticsData().cacheMissExpired();
    }

    public void xaCommit() {
        this.getDelegateAsLiveStatisticsData().xaCommit();
    }

    public void xaRollback() {
        this.getDelegateAsLiveStatisticsData().xaRollback();
    }

    public void cacheMissNotFound() {
        this.getDelegateAsLiveStatisticsData().cacheMissNotFound();
    }

    public void cacheMissInMemory() {
        this.getDelegateAsLiveStatisticsData().cacheMissInMemory();
    }

    public void cacheMissOffHeap() {
        this.getDelegateAsLiveStatisticsData().cacheMissOffHeap();
    }

    public void cacheMissOnDisk() {
        this.getDelegateAsLiveStatisticsData().cacheMissOnDisk();
    }

    public void clearStatistics() {
        this.getDelegateAsLiveStatisticsData().clearStatistics();
    }

    public void dispose() {
        this.getDelegateAsLiveStatisticsData().dispose();
    }

    public void notifyElementEvicted(Ehcache cache, Element element) {
        this.getDelegateAsLiveStatisticsData().notifyElementEvicted(cache, element);
    }

    public void notifyElementExpired(Ehcache cache, Element element) {
        this.getDelegateAsLiveStatisticsData().notifyElementExpired(cache, element);
    }

    public void notifyElementPut(Ehcache cache, Element element) throws CacheException {
        this.getDelegateAsLiveStatisticsData().notifyElementPut(cache, element);
    }

    public void notifyElementRemoved(Ehcache cache, Element element) throws CacheException {
        this.getDelegateAsLiveStatisticsData().notifyElementRemoved(cache, element);
    }

    public void notifyElementUpdated(Ehcache cache, Element element) throws CacheException {
        this.getDelegateAsLiveStatisticsData().notifyElementUpdated(cache, element);
    }

    public void notifyRemoveAll(Ehcache cache) {
        this.getDelegateAsLiveStatisticsData().notifyRemoveAll(cache);
    }

    public Object clone() throws CloneNotSupportedException {
        super.clone();
        throw new CloneNotSupportedException();
    }
}

