/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.resources.gcore.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class ReadOnlyGroup<T> {
    protected final Collection<T> base;
    protected final Class<? extends T> clazz;

    public ReadOnlyGroup(Collection<T> values, Class<? extends T> clazz) {
        this.base = values;
        this.clazz = clazz;
    }

    protected T add() {
        try {
            T t = this.clazz.newInstance();
            this.add(t);
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("invalid model class, cannot be instantiated reflectively", e);
        }
    }

    protected <S extends T> S add(Class<S> subclass) {
        try {
            S s = subclass.newInstance();
            this.add(s);
            return s;
        }
        catch (Exception e) {
            throw new RuntimeException("invalid model class, cannot be instantiated reflectively", e);
        }
    }

    protected void clear() {
        this.base.clear();
    }

    public boolean contains(Object o) {
        return this.base.contains(o);
    }

    public boolean containsAll(Collection<?> c) {
        return this.base.containsAll(c);
    }

    public boolean containsAll(Object ... elements) {
        return this.base.containsAll(Arrays.asList(elements));
    }

    public boolean equals(Object o) {
        return ((Object)this.base).equals(o);
    }

    public int hashCode() {
        return ((Object)this.base).hashCode();
    }

    public boolean isEmpty() {
        return this.base.isEmpty();
    }

    protected boolean removeAll(Collection<?> c) {
        return this.base.removeAll(c);
    }

    protected boolean removeAll(Object ... elements) {
        return this.base.removeAll(Arrays.asList(elements));
    }

    protected boolean retainAll(Collection<?> c) {
        return this.base.retainAll(c);
    }

    protected boolean retainAll(Object ... elements) {
        return this.base.retainAll(Arrays.asList(elements));
    }

    public int size() {
        return this.base.size();
    }

    public Object[] toArray() {
        return this.base.toArray();
    }

    public <E> E[] toArray(E[] a) {
        return this.base.toArray(a);
    }

    public Iterator<T> iterator() {
        return this.base.iterator();
    }

    protected boolean add(T element) {
        return this.base.add(element);
    }

    protected boolean remove(Object element) {
        return this.base.remove(element);
    }
}

