/*
 * Decompiled with CFR 0.152.
 */
package org.globus.wsrf.impl.notification;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.globus.util.I18n;
import org.globus.wsrf.NoSuchResourceException;
import org.globus.wsrf.Resource;
import org.globus.wsrf.ResourceContext;
import org.globus.wsrf.Subscription;
import org.globus.wsrf.utils.FaultHelper;
import org.globus.wsrf.utils.Resources;
import org.oasis.wsn.PauseFailedFaultType;
import org.oasis.wsn.PauseSubscription;
import org.oasis.wsn.PauseSubscriptionResponse;
import org.oasis.wsn.ResourceUnknownFaultType;
import org.oasis.wsrf.faults.BaseFaultType;

public class PauseSubscriptionProvider {
    static Log logger = LogFactory.getLog((String)PauseSubscriptionProvider.class.getName());
    private static I18n i18n = I18n.getI18n((String)Resources.class.getName());

    public PauseSubscriptionResponse pauseSubscription(PauseSubscription request) throws RemoteException, ResourceUnknownFaultType, PauseFailedFaultType {
        Resource resource = null;
        try {
            resource = ResourceContext.getResourceContext().getResource();
        }
        catch (NoSuchResourceException e) {
            ResourceUnknownFaultType fault = new ResourceUnknownFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.setDescription(i18n.getMessage("resourceDisoveryFailed"));
            faultHelper.addFaultCause(e);
            throw fault;
        }
        catch (Exception e) {
            throw new RemoteException(i18n.getMessage("resourceDisoveryFailed"), e);
        }
        try {
            ((Subscription)resource).pause();
        }
        catch (Exception e) {
            PauseFailedFaultType fault = new PauseFailedFaultType();
            FaultHelper faultHelper = new FaultHelper((BaseFaultType)fault);
            faultHelper.addFaultCause(e);
            throw fault;
        }
        return new PauseSubscriptionResponse();
    }
}

