/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.utils.encryption;

import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.spec.SecretKeySpec;
import org.apache.xml.security.utils.JavaUtils;

final class SymmetricKey {
    private static Key key;
    private static String localKey;
    private static String keyAlgorithm;

    private SymmetricKey() {
    }

    protected static Key getKey() throws InvalidKeyException {
        if (key == null) {
            SymmetricKey.load();
        }
        return key;
    }

    private static void load() throws InvalidKeyException {
        byte[] rawKey;
        try {
            rawKey = JavaUtils.getBytesFromStream((InputStream)SymmetricKey.class.getResourceAsStream(localKey));
        }
        catch (Exception e) {
            System.out.println("Unable to load the Key from the classpath");
            e.printStackTrace();
            throw new InvalidKeyException();
        }
        try {
            key = new SecretKeySpec(rawKey, 0, rawKey.length, keyAlgorithm);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidKeyException();
        }
    }

    static {
        localKey = "/symm.key";
        keyAlgorithm = "AES";
    }
}

