/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.handlers;

import java.rmi.Remote;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.contexts.GCUBERemotePortTypeContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBERetryEquivalentException;
import org.gcube.common.core.faults.GCUBERetrySameException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.informationsystem.client.AtomicCondition;
import org.gcube.common.core.informationsystem.client.ISClient;
import org.gcube.common.core.informationsystem.client.ISQuery;
import org.gcube.common.core.informationsystem.client.queries.GCUBERIQuery;
import org.gcube.common.core.resources.GCUBERunningInstance;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.utils.handlers.GCUBEServiceHandler;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.informationsystem.notifier.stubs.NotifierPortType;
import org.gcube.informationsystem.notifier.stubs.service.NotifierServiceAddressingLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NotifierCall<PARAMETER, RETURN>
implements Runnable {
    private static Map<String, EndpointReferenceType> eprCache = new HashMap<String, EndpointReferenceType>();
    private static GCUBELog logger = new GCUBELog(NotifierCall.class);
    private PARAMETER parameter;
    private RETURN returnValue;
    private int maxAttempt = 5;
    private int waitTime = 20;
    private GCUBEScope scope;
    private GCUBESecurityManager secMan;
    private Exception exception = null;
    private State state;

    public NotifierCall(GCUBEScope gCUBEScope, GCUBESecurityManager gCUBESecurityManager) {
        this.scope = gCUBEScope;
        this.secMan = gCUBESecurityManager;
    }

    @Override
    public void run() {
        if (eprCache.get(this.scope.toString()) != null) {
            try {
                logger.trace((Object)"using cache");
                this.tryInstances(Collections.singletonList(eprCache.get(this.scope.toString())));
                return;
            }
            catch (Exception exception) {
                logger.warn((Object)("(cached) lastException error is " + exception.getMessage()), (Throwable)exception);
                eprCache.remove(this.scope.toString());
            }
        }
        int n = 0;
        ArrayList<EndpointReferenceType> arrayList = new ArrayList();
        do {
            try {
                arrayList = this.findInstance();
                this.exception = null;
            }
            catch (GCUBEServiceHandler.NoQueryResultException noQueryResultException) {
                logger.warn((Object)("no eprs retrieved, retrying in " + this.getWaitTime() + " secs (attempt number " + n + ")"));
                ++n;
                this.exception = noQueryResultException;
                try {
                    Thread.sleep(20000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        } while (this.exception != null && n <= this.maxAttempt);
        if (this.exception != null) {
            this.state = State.FAILED;
            return;
        }
        try {
            eprCache.put(this.scope.toString(), this.tryInstances(arrayList));
            return;
        }
        catch (Exception exception) {
            this.exception = exception;
            this.state = State.FAILED;
            return;
        }
    }

    protected void _interact(EndpointReferenceType endpointReferenceType) throws Exception {
        NotifierServiceAddressingLocator notifierServiceAddressingLocator = new NotifierServiceAddressingLocator();
        NotifierPortType notifierPortType = notifierServiceAddressingLocator.getNotifierPortTypePort(endpointReferenceType);
        notifierPortType = (NotifierPortType)GCUBERemotePortTypeContext.getProxy((Remote)notifierPortType, (GCUBEScope)this.scope, (GCUBESecurityManager[])new GCUBESecurityManager[]{this.secMan});
        this.returnValue = this.makeCall(notifierPortType);
    }

    protected abstract RETURN makeCall(NotifierPortType var1) throws Exception;

    protected List<EndpointReferenceType> findInstance() throws GCUBEServiceHandler.NoQueryResultException {
        try {
            ISClient iSClient = (ISClient)GHNContext.getImplementation(ISClient.class);
            GCUBERIQuery gCUBERIQuery = (GCUBERIQuery)iSClient.getQuery(GCUBERIQuery.class);
            gCUBERIQuery.addAtomicConditions(new AtomicCondition[]{new AtomicCondition("//ServiceName", "IS-Notifier")});
            ArrayList<EndpointReferenceType> arrayList = new ArrayList<EndpointReferenceType>();
            for (GCUBERunningInstance gCUBERunningInstance : iSClient.execute((ISQuery)gCUBERIQuery, this.scope)) {
                arrayList.add(gCUBERunningInstance.getAccessPoint().getEndpoint("gcube/informationsystem/notifier/Notifier"));
            }
            if (arrayList.size() == 0) {
                throw new Exception("no RI of notifier retrieved");
            }
            return arrayList;
        }
        catch (Exception exception) {
            logger.warn((Object)exception);
            throw new GCUBEServiceHandler.NoQueryResultException();
        }
    }

    protected EndpointReferenceType tryInstances(List<EndpointReferenceType> list) throws Exception {
        ArrayList<EndpointReferenceType> arrayList;
        int n = 0;
        Throwable throwable = null;
        do {
            arrayList = new ArrayList<EndpointReferenceType>();
            ++n;
            for (EndpointReferenceType endpointReferenceType : list) {
                if (endpointReferenceType == null) continue;
                try {
                    logger.info((Object)("trying instance  @ " + endpointReferenceType.getAddress()));
                    this._interact(endpointReferenceType);
                    return endpointReferenceType;
                }
                catch (GCUBEUnrecoverableException gCUBEUnrecoverableException) {
                    throw gCUBEUnrecoverableException;
                }
                catch (GCUBERetrySameException gCUBERetrySameException) {
                    throwable = gCUBERetrySameException;
                    logger.info((Object)("trying again later @ " + endpointReferenceType.getAddress()));
                    arrayList.add(endpointReferenceType);
                }
                catch (GCUBERetryEquivalentException gCUBERetryEquivalentException) {
                    throwable = gCUBERetryEquivalentException;
                    logger.warn((Object)("error connecting instance " + endpointReferenceType.getAddress()), (Throwable)gCUBERetryEquivalentException);
                }
                catch (Exception exception) {
                    throwable = exception;
                    logger.error((Object)("failed @ instance " + endpointReferenceType.getAddress()), (Throwable)exception);
                }
            }
        } while (!(list = arrayList).isEmpty() && n < 2);
        throw throwable;
    }

    public PARAMETER getParameter() {
        return this.parameter;
    }

    public void setParameter(PARAMETER PARAMETER) {
        this.parameter = PARAMETER;
    }

    public RETURN getReturnValue() {
        return this.returnValue;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int n) {
        this.waitTime = n;
    }

    public int getMaxAttempts() {
        return this.maxAttempt;
    }

    public void setMaxAttempts(int n) {
        this.maxAttempt = n;
    }

    public GCUBEScope getScope() {
        return this.scope;
    }

    public void setScope(GCUBEScope gCUBEScope) {
        this.scope = gCUBEScope;
    }

    public GCUBESecurityManager getSecMan() {
        return this.secMan;
    }

    public void setSecMan(GCUBESecurityManager gCUBESecurityManager) {
        this.secMan = gCUBESecurityManager;
    }

    public Exception getException() {
        return this.exception;
    }

    public State getState() {
        return this.state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        FAILED,
        SUCCESS;

    }
}

