/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.naming.ContextBindings;
import org.apache.naming.NamingContext;
import org.apache.naming.StringManager;
import org.apache.naming.SynchronizedContext;

public class SelectorContext
implements Context {
    public static final String prefix = "java:";
    public static final int prefixLength = "java:".length();
    public static final String IC_PREFIX = "IC_";
    protected Hashtable env;
    protected StringManager sm = StringManager.getManager("org.apache.naming");
    protected boolean initialContext = false;

    public SelectorContext(Hashtable hashtable) {
        this.env = hashtable;
    }

    public SelectorContext(Hashtable hashtable, boolean bl) {
        this(hashtable);
        this.initialContext = bl;
    }

    public Object lookup(Name name) throws NamingException {
        return this.getBoundContext().lookup(this.parseName(name));
    }

    public Object lookup(String string) throws NamingException {
        return this.getBoundContext().lookup(this.parseName(string));
    }

    public void bind(Name name, Object object) throws NamingException {
        this.getBoundContext().bind(this.parseName(name), object);
    }

    public void bind(String string, Object object) throws NamingException {
        this.getBoundContext().bind(this.parseName(string), object);
    }

    public void rebind(Name name, Object object) throws NamingException {
        this.getBoundContext().rebind(this.parseName(name), object);
    }

    public void rebind(String string, Object object) throws NamingException {
        this.getBoundContext().rebind(this.parseName(string), object);
    }

    public void unbind(Name name) throws NamingException {
        this.getBoundContext().unbind(this.parseName(name));
    }

    public void unbind(String string) throws NamingException {
        this.getBoundContext().unbind(this.parseName(string));
    }

    public void rename(Name name, Name name2) throws NamingException {
        this.getBoundContext().rename(this.parseName(name), this.parseName(name2));
    }

    public void rename(String string, String string2) throws NamingException {
        this.getBoundContext().rename(this.parseName(string), this.parseName(string2));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.getBoundContext().list(this.parseName(name));
    }

    public NamingEnumeration list(String string) throws NamingException {
        return this.getBoundContext().list(this.parseName(string));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.getBoundContext().listBindings(this.parseName(name));
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        return this.getBoundContext().listBindings(this.parseName(string));
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(name));
    }

    public void destroySubcontext(String string) throws NamingException {
        this.getBoundContext().destroySubcontext(this.parseName(string));
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(name));
    }

    public Context createSubcontext(String string) throws NamingException {
        return this.getBoundContext().createSubcontext(this.parseName(string));
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.getBoundContext().lookupLink(this.parseName(name));
    }

    public Object lookupLink(String string) throws NamingException {
        return this.getBoundContext().lookupLink(this.parseName(string));
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(name));
    }

    public NameParser getNameParser(String string) throws NamingException {
        return this.getBoundContext().getNameParser(this.parseName(string));
    }

    public Name composeName(Name name, Name name2) throws NamingException {
        name2 = (Name)name.clone();
        return name2.addAll(name);
    }

    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.getBoundContext().addToEnvironment(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.getBoundContext().removeFromEnvironment(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.getBoundContext().getEnvironment();
    }

    public void close() throws NamingException {
        this.getBoundContext().close();
    }

    public String getNameInNamespace() throws NamingException {
        return prefix;
    }

    protected Context getBoundContext() throws NamingException {
        if (this.initialContext) {
            String string = IC_PREFIX;
            if (ContextBindings.isThreadBound()) {
                string = string + ContextBindings.getThreadName();
            } else if (ContextBindings.isClassLoaderBound()) {
                string = string + ContextBindings.getClassLoaderName();
            }
            Context context = ContextBindings.getContext(string);
            if (context == null) {
                context = new NamingContext(this.env, string);
                if (SynchronizedContext.isSynchronized(this.env)) {
                    context = new SynchronizedContext(context);
                }
                ContextBindings.bindContext(string, context);
            }
            return context;
        }
        if (ContextBindings.isThreadBound()) {
            return ContextBindings.getThread();
        }
        return ContextBindings.getClassLoader();
    }

    protected String parseName(String string) throws NamingException {
        if (!this.initialContext && string.startsWith(prefix)) {
            return string.substring(prefixLength);
        }
        if (this.initialContext) {
            return string;
        }
        throw new NamingException(this.sm.getString("selectorContext.noJavaUrl"));
    }

    protected Name parseName(Name name) throws NamingException {
        if (!this.initialContext && !name.isEmpty() && name.get(0).equals(prefix)) {
            return name.getSuffix(1);
        }
        if (this.initialContext) {
            return name;
        }
        throw new NamingException(this.sm.getString("selectorContext.noJavaUrl"));
    }
}

