/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.platforms;

import java.io.File;
import java.util.List;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.resources.common.PlatformDescription;
import org.gcube.vremanagement.virtualplatform.image.PlatformConfiguration;
import org.gcube.vremanagement.virtualplatform.image.Platforms;
import org.gcube.vremanagement.virtualplatform.image.VirtualPlatform;

public class Finder {
    private static List<PlatformConfiguration> availablePlatforms;

    public static VirtualPlatform find(PlatformDescription platformDescription) throws Exception {
        availablePlatforms = Platforms.listAvailablePlatforms((File)new File(GHNContext.getContext().getVirtualPlatformsLocation()));
        VirtualPlatform vplatform = null;
        for (PlatformConfiguration configuration : availablePlatforms) {
            if (!configuration.getName().equalsIgnoreCase(platformDescription.getName()) || configuration.getVersion() != platformDescription.getVersion()) continue;
            vplatform = new VirtualPlatform(configuration);
            break;
        }
        if (vplatform == null) {
            throw new PlatformNotAvailableException("Unable to find platform " + platformDescription + " on this node");
        }
        return vplatform;
    }

    public static class PlatformNotAvailableException
    extends Exception {
        private static final long serialVersionUID = 6692317497612642118L;

        protected PlatformNotAvailableException() {
        }

        protected PlatformNotAvailableException(String msg) {
            super(msg);
        }
    }
}

